/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.visitor.ReturnVisitor;

public abstract class AbstractCollector<T>
implements ReturnVisitor<Set<T>, Set<T>, Set<T>, Set<T>> {
    protected final Map<Node, Set<T>> cache;
    protected final Set<Node> cached;

    protected AbstractCollector(Set<Node> set) {
        this.cached = set;
        this.cache = new IdentityHashMap<Node, Set<T>>(set.size());
    }

    protected AbstractCollector(Set<Node> set, Map<Node, Set<T>> map) {
        this.cached = set;
        this.cache = map;
    }

    protected Set<T> lookup(Node node) {
        return this.cache.get(node);
    }

    protected Set<T> cache(Node node, Set<T> set) {
        if (this.cached.contains(node)) {
            this.cache.put(node, this.reduce(set));
        }
        return set;
    }

    protected Set<T> reduce(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return set;
    }

    protected abstract Set<T> newSet();

    @Override
    public Set<T> visit(Decls decls) {
        Set<T> set = this.lookup(decls);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        for (Decl decl : decls) {
            set.addAll((Collection)decl.accept(this));
        }
        return this.cache(decls, set);
    }

    @Override
    public Set<T> visit(Decl decl) {
        Set<T> set = this.lookup(decl);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)decl.variable().accept(this));
        set.addAll((Collection)decl.expression().accept(this));
        return this.cache(decl, set);
    }

    @Override
    public Set<T> visit(Relation relation) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<T> visit(Variable variable) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<T> visit(ConstantExpression constantExpression) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<T> visit(NaryExpression naryExpression) {
        Set<T> set = this.lookup(naryExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        for (Expression expression : naryExpression) {
            set.addAll((Collection)expression.accept(this));
        }
        return this.cache(naryExpression, set);
    }

    @Override
    public Set<T> visit(BinaryExpression binaryExpression) {
        Set<T> set = this.lookup(binaryExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)binaryExpression.left().accept(this));
        set.addAll((Collection)binaryExpression.right().accept(this));
        return this.cache(binaryExpression, set);
    }

    @Override
    public Set<T> visit(UnaryExpression unaryExpression) {
        Set<T> set = this.lookup(unaryExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)unaryExpression.expression().accept(this));
        return this.cache(unaryExpression, set);
    }

    @Override
    public Set<T> visit(Comprehension comprehension) {
        Set<T> set = this.lookup(comprehension);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)comprehension.decls().accept(this));
        set.addAll((Collection)comprehension.formula().accept(this));
        return this.cache(comprehension, set);
    }

    @Override
    public Set<T> visit(IfExpression ifExpression) {
        Set<T> set = this.lookup(ifExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)ifExpression.condition().accept(this));
        set.addAll((Collection)ifExpression.thenExpr().accept(this));
        set.addAll((Collection)ifExpression.elseExpr().accept(this));
        return this.cache(ifExpression, set);
    }

    @Override
    public Set<T> visit(ProjectExpression projectExpression) {
        Set<T> set = this.lookup(projectExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)projectExpression.expression().accept(this));
        int n = projectExpression.arity();
        for (int i = 0; i < n; ++i) {
            set.addAll((Collection)projectExpression.column(i).accept(this));
        }
        return this.cache(projectExpression, set);
    }

    @Override
    public Set<T> visit(IntToExprCast intToExprCast) {
        Set<T> set = this.lookup(intToExprCast);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)intToExprCast.intExpr().accept(this));
        return this.cache(intToExprCast, set);
    }

    @Override
    public Set<T> visit(IntConstant intConstant) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<T> visit(IfIntExpression ifIntExpression) {
        Set<T> set = this.lookup(ifIntExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)ifIntExpression.condition().accept(this));
        set.addAll((Collection)ifIntExpression.thenExpr().accept(this));
        set.addAll((Collection)ifIntExpression.elseExpr().accept(this));
        return this.cache(ifIntExpression, set);
    }

    @Override
    public Set<T> visit(ExprToIntCast exprToIntCast) {
        Set<T> set = this.lookup(exprToIntCast);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)exprToIntCast.expression().accept(this));
        return this.cache(exprToIntCast, set);
    }

    @Override
    public Set<T> visit(NaryIntExpression naryIntExpression) {
        Set<T> set = this.lookup(naryIntExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        for (IntExpression intExpression : naryIntExpression) {
            set.addAll((Collection)intExpression.accept(this));
        }
        return this.cache(naryIntExpression, set);
    }

    @Override
    public Set<T> visit(BinaryIntExpression binaryIntExpression) {
        Set<T> set = this.lookup(binaryIntExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)binaryIntExpression.left().accept(this));
        set.addAll((Collection)binaryIntExpression.right().accept(this));
        return this.cache(binaryIntExpression, set);
    }

    @Override
    public Set<T> visit(UnaryIntExpression unaryIntExpression) {
        Set<T> set = this.lookup(unaryIntExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)unaryIntExpression.intExpr().accept(this));
        return this.cache(unaryIntExpression, set);
    }

    @Override
    public Set<T> visit(SumExpression sumExpression) {
        Set<T> set = this.lookup(sumExpression);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)sumExpression.decls().accept(this));
        set.addAll((Collection)sumExpression.intExpr().accept(this));
        return this.cache(sumExpression, set);
    }

    @Override
    public Set<T> visit(IntComparisonFormula intComparisonFormula) {
        Set<T> set = this.lookup(intComparisonFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)intComparisonFormula.left().accept(this));
        set.addAll((Collection)intComparisonFormula.right().accept(this));
        return this.cache(intComparisonFormula, set);
    }

    @Override
    public Set<T> visit(QuantifiedFormula quantifiedFormula) {
        Set<T> set = this.lookup(quantifiedFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)quantifiedFormula.decls().accept(this));
        set.addAll((Collection)quantifiedFormula.formula().accept(this));
        return this.cache(quantifiedFormula, set);
    }

    @Override
    public Set<T> visit(NaryFormula naryFormula) {
        Set<T> set = this.lookup(naryFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        for (Formula formula : naryFormula) {
            set.addAll((Collection)formula.accept(this));
        }
        return this.cache(naryFormula, set);
    }

    @Override
    public Set<T> visit(BinaryFormula binaryFormula) {
        Set<T> set = this.lookup(binaryFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)binaryFormula.left().accept(this));
        set.addAll((Collection)binaryFormula.right().accept(this));
        return this.cache(binaryFormula, set);
    }

    @Override
    public Set<T> visit(NotFormula notFormula) {
        Set<T> set = this.lookup(notFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)notFormula.formula().accept(this));
        return this.cache(notFormula, set);
    }

    @Override
    public Set<T> visit(ConstantFormula constantFormula) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<T> visit(ComparisonFormula comparisonFormula) {
        Set<T> set = this.lookup(comparisonFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)comparisonFormula.left().accept(this));
        set.addAll((Collection)comparisonFormula.right().accept(this));
        return this.cache(comparisonFormula, set);
    }

    @Override
    public Set<T> visit(MultiplicityFormula multiplicityFormula) {
        Set<T> set = this.lookup(multiplicityFormula);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)multiplicityFormula.expression().accept(this));
        return this.cache(multiplicityFormula, set);
    }

    @Override
    public Set<T> visit(RelationPredicate relationPredicate) {
        Set<T> set = this.lookup(relationPredicate);
        if (set != null) {
            return set;
        }
        set = this.newSet();
        set.addAll((Collection)relationPredicate.relation().accept(this));
        switch (relationPredicate.name()) {
            case ACYCLIC: {
                break;
            }
            case FUNCTION: {
                RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
                set.addAll((Collection)function.domain().accept(this));
                set.addAll((Collection)function.range().accept(this));
                break;
            }
            case TOTAL_ORDERING: {
                RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
                set.addAll((Collection)totalOrdering.ordered().accept(this));
                set.addAll((Collection)totalOrdering.first().accept(this));
                set.addAll((Collection)totalOrdering.last().accept(this));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown relation predicate: " + (Object)((Object)relationPredicate.name()));
            }
        }
        return this.cache(relationPredicate, set);
    }
}

