/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.IntExpression;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class UnaryIntExpression
extends IntExpression {
    private final IntOperator op;
    private final IntExpression intExpr;

    UnaryIntExpression(IntOperator intOperator, IntExpression intExpression) {
        if (!intOperator.unary()) {
            throw new IllegalArgumentException("Not a unary operator: " + (Object)((Object)intOperator));
        }
        this.op = intOperator;
        this.intExpr = intExpression;
    }

    public IntOperator op() {
        return this.op;
    }

    public IntExpression intExpr() {
        return this.intExpr;
    }

    @Override
    public <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.op == IntOperator.NEG || this.op == IntOperator.NOT ? "(" + (Object)((Object)this.op) + this.intExpr + ")" : (Object)((Object)this.op) + "(" + this.intExpr + ")";
    }
}

