/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Iterator;
import kodkod.ast.IntExpression;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;
import kodkod.util.collections.Containers;

public final class NaryIntExpression
extends IntExpression
implements Iterable<IntExpression> {
    private final IntOperator op;
    private final IntExpression[] children;

    NaryIntExpression(IntOperator intOperator, IntExpression[] intExpressionArray) {
        assert (intExpressionArray.length > 2);
        if (!intOperator.nary()) {
            throw new IllegalArgumentException("Cannot construct an nary int expression using the non-nary operator " + (Object)((Object)intOperator));
        }
        this.op = intOperator;
        this.children = intExpressionArray;
    }

    public IntOperator op() {
        return this.op;
    }

    public int size() {
        return this.children.length;
    }

    public IntExpression child(int n) {
        return this.children[n];
    }

    @Override
    public Iterator<IntExpression> iterator() {
        return Containers.iterate(this.children);
    }

    @Override
    public <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.child(0));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)this.op);
            stringBuilder.append(" ");
            stringBuilder.append(this.child(i));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

