/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Iterator;
import kodkod.ast.Expression;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;
import kodkod.util.collections.Containers;

public final class NaryExpression
extends Expression
implements Iterable<Expression> {
    private final ExprOperator op;
    private final int arity;
    private final Expression[] children;

    NaryExpression(ExprOperator exprOperator, Expression[] expressionArray) {
        assert (expressionArray.length > 2);
        if (!exprOperator.nary()) {
            throw new IllegalArgumentException("Cannot construct an nary expression using the non-nary operator " + (Object)((Object)exprOperator));
        }
        this.op = exprOperator;
        this.children = expressionArray;
        switch (exprOperator) {
            case UNION: 
            case INTERSECTION: 
            case OVERRIDE: {
                this.arity = expressionArray[0].arity();
                for (int i = 1; i < expressionArray.length; ++i) {
                    if (expressionArray[i].arity() == this.arity) continue;
                    throw new IllegalArgumentException("Incompatible arities: " + expressionArray[0] + " and " + expressionArray[i]);
                }
                break;
            }
            case PRODUCT: {
                int n = 0;
                for (Expression expression : expressionArray) {
                    n += expression.arity();
                }
                this.arity = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown associative operator: " + (Object)((Object)exprOperator));
            }
        }
    }

    @Override
    public final int arity() {
        return this.arity;
    }

    public ExprOperator op() {
        return this.op;
    }

    public int size() {
        return this.children.length;
    }

    public Expression child(int n) {
        return this.children[n];
    }

    @Override
    public Iterator<Expression> iterator() {
        return Containers.iterate(this.children);
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.child(0));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)this.op);
            stringBuilder.append(" ");
            stringBuilder.append(this.child(i));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

