/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class IfExpression
extends Expression {
    private final Formula condition;
    private final Expression thenExpr;
    private final Expression elseExpr;
    private final int arity;

    IfExpression(Formula formula, Expression expression, Expression expression2) {
        if (expression.arity() != expression2.arity()) {
            throw new IllegalArgumentException("Arity mismatch: " + expression + "::" + expression.arity() + " and " + expression2 + "::" + expression2.arity());
        }
        this.condition = formula;
        this.thenExpr = expression;
        this.elseExpr = expression2;
        this.arity = expression.arity();
    }

    public Formula condition() {
        return this.condition;
    }

    public Expression thenExpr() {
        return this.thenExpr;
    }

    public Expression elseExpr() {
        return this.elseExpr;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "(if " + this.condition + " then " + this.thenExpr + " else " + this.elseExpr + ")";
    }
}

