/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.operator.ExprCompOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class ComparisonFormula
extends Formula {
    private final Expression left;
    private final Expression right;
    private final ExprCompOperator op;

    ComparisonFormula(Expression expression, ExprCompOperator exprCompOperator, Expression expression2) {
        if (expression.arity() != expression2.arity()) {
            throw new IllegalArgumentException("Arity mismatch: " + expression + "::" + expression.arity() + " and " + expression2 + "::" + expression2.arity());
        }
        this.left = expression;
        this.right = expression2;
        this.op = exprCompOperator;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public ExprCompOperator op() {
        return this.op;
    }

    @Override
    public <E, F, D, I> F accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }
}

