/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.IntExpression;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class BinaryIntExpression
extends IntExpression {
    private final IntOperator op;
    private final IntExpression left;
    private final IntExpression right;

    public BinaryIntExpression(IntExpression intExpression, IntOperator intOperator, IntExpression intExpression2) {
        if (!intOperator.binary()) {
            throw new IllegalArgumentException("Not a binary operator: " + (Object)((Object)intOperator));
        }
        this.left = intExpression;
        this.right = intExpression2;
        this.op = intOperator;
    }

    public IntExpression left() {
        return this.left;
    }

    public IntExpression right() {
        return this.right;
    }

    public IntOperator op() {
        return this.op;
    }

    @Override
    public <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }
}

