/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define _GNU_SOURCE
#define _REENTRANT

#include <stdlib.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include<errno.h>
#include <sys/epoll.h>
#include<libaio.h>

#define MAXEVENT 65500
#define MAXRESULT 100

static io_context_t ctx = 0;

void c_aio_setup (void) {
  int res = io_setup(MAXEVENT, &ctx);
  assert (res==0);
}

int c_file_open(const char * name, int mode) {
  int flags;
  if (mode==1)      flags = (O_RDONLY|O_DIRECT);
  else if (mode==2) flags = (O_WRONLY|O_DIRECT);
  else if (mode==3) flags = (O_RDWR|O_DIRECT);
  else assert("Bad file open mode"==0);
  int fd = open(name,  flags);
  return fd;
}

int c_file_close(int fd) {
  int res= close(fd);
  assert(res>=0);
  return res;
}

void c_file_read(int fd, 
		long long file_offset,  
		void * buffer,
		int length,
		void * ref)
{
  struct iocb* cb;
  struct iocb* cb_array[1];
  cb = (struct iocb *) malloc (sizeof(struct iocb));
  cb_array[0] = cb;
  io_prep_pread(cb, fd, buffer, length, file_offset);
  //printf("{%d} io_submit buffer_addr=%p len=%d cb=%p ref_addr=%p\n", fd, buffer, length, cb, ref);
  cb->data = ref;
  int res = io_submit(ctx, 1, cb_array);
  assert (res >0);
}

static struct io_event ev_result[MAXRESULT];

int c_file_wait(int timeout) {
  int res;
  struct timespec timer;
  if (timeout < 0) {
    res = io_getevents( ctx, 1, 1, ev_result, NULL);
  } else {
    long tmp = timeout % 1000;
    timer.tv_sec = timeout / 1000;
    timer.tv_nsec = tmp * 1000 * 1000;
    res = io_getevents( ctx, 1, 1, ev_result, &timer);
  }
  if (res < 0)
    printf("io_getevents res = %s\n", strerror(-res));
  // assert(res >=0);
  //  if (res >= 0) {
  //    printf("io_getevents_ok res = %d\n", res);
  //    int r = ev_result[0].res; 
  //    void* ref = ev_result[0].data; 
  //    struct iocb * cb =  ev_result[0].obj; 
  //    printf("io_getevents_ok bytes_read=%d cb=%p ref_addr=%p\n", r, cb, ref);
  //  }
  //

  return res;
  // <0: error
  //  0: nothing
  //  n: number of events read
}

int c_file_getresult(int index) {
  int r = ev_result[index].res; 
  void* ref = ev_result[index].data; 
  struct iocb * cb =  ev_result[index].obj; 
  if (r < 0) {
    printf("ev_result[index].res = %s\n", strerror(-r));
  }
  //printf("io_getevents bytes_read=%d cb=%p ref_addr=%p\n", r, cb, ref);
  assert (r>=0);
  free(ev_result[index].obj);
  return r;
}

void* c_file_getref(int index) {
  return ev_result[index].data;
}
