{--
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--}

module Util (
  get_current_time -- :: IO Int64              -- in microseconds
, find_local_addr  -- :: Word32 -> IO Word32   -- host-ordered IP addresses
, dns_lookup       -- :: String -> IO Word32   -- host-ordered IP address
)

where
import System.IO
import Foreign
import Foreign.C
import Chunk
import Data.Maybe

get_current_time :: IO Int64
get_current_time = do
  ll <- c_get_time
  return $ fromIntegral ll
foreign import ccall "mod_util.h c_get_time"  
  c_get_time :: IO CLLong


foreign import ccall "mod_util.h c_find_local_addr" 
  find_local_addr :: Word32 -> IO Word32


foreign import ccall "mod_util.h c_dns_lookup" 
  c_dns_lookup :: Ptr CChar -> IO Word32

-- returns 0 on failure, otherwise returns the 32-bit ip address
dns_lookup :: String -> IO Word32
dns_lookup s = 
  do ptr <- newCString s
     res <- c_dns_lookup ptr
     free ptr
     return res
