/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define _REENTRANT

#include <stdlib.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <netdb.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <net/if.h>

#include <unistd.h>
#include <string.h>

#include <sys/time.h>

long long c_get_time (void) {
       struct timeval now;
       gettimeofday(&now, NULL);
       long long sec = now.tv_sec;
       long long usec = now.tv_usec;
       sec = sec*1000000 + usec;
       return sec;
}


// ----------- routing -------------------------------------------------

struct in_addr find_if_addr(char* if_name) { 
  int sockd;
  if((sockd = socket(PF_INET,SOCK_DGRAM,IPPROTO_IP)) < 0)  {
    perror("socket");
    exit(1);
  }
  struct ifreq req[97];
  struct ifconf f;
  f.ifc_len = 96;
  f.ifc_ifcu.ifcu_req = req;
  if (ioctl(sockd,  SIOCGIFCONF, &f) < 0 ) {
    perror("ioctl");
    exit(1);
  }
  close(sockd);
  //printf("%d\n", f.ifc_len); 
  int i;
  for (i=0; *(req[i].ifr_name)!=0; i++) {
    struct sockaddr_in* addr =  (struct sockaddr_in*) &(req[i].ifr_addr);
    //printf("%s %s\n", req[i].ifr_name, inet_ntoa(addr->sin_addr));
    if (strcmp( req[i].ifr_name, if_name) == 0)
      return addr->sin_addr;
  }
  // not found
  perror("find_if_addr: cannot find interface address");
  exit(1);
}

find_route(struct in_addr remote_addr, char * if_name) {
  unsigned int remote = *((unsigned int*)(&remote_addr));
  if (remote==0 || (remote & 0x0000007F) ==0x0000007F) {
    strcpy(if_name, "lo");
    return;
  }

  FILE *fp = fopen("/proc/net/route", "r");
  char linebuf[200];
  fgets(linebuf, 199, fp);
  unsigned int x1,x2,x3,x4,x5,x6,x7,dest, mask;

  while(fgets(linebuf, 199, fp)) {
      sscanf(linebuf, "%s%x%x%x%x%x%x%x", if_name, &x1, &x2,&x3,&x4,&x5,&x6, &x7);
      //printf("%s %08X %08X\n", if_name, x1, x7);
      dest = x1; mask = x7;
      if ( (remote& mask)==dest ) {
	fclose(fp);
	return;
      }
  }
  fclose(fp);
  perror("find_route: cannot find route");
  exit(1);
}

struct in_addr find_local_addr_(struct in_addr remote_addr) {
  char if_name[100];
  if_name[0] = 0;
  find_route(remote_addr, if_name);
  if (if_name[0]==0) {
    perror("internal error: find_route");
    exit(1);
  }
  return find_if_addr(if_name);
}

unsigned int c_find_local_addr( unsigned int remote) {
  struct in_addr remote_addr = *((struct in_addr*)(&remote));
  struct in_addr local_addr = find_local_addr_(remote_addr);
  unsigned int local = *((unsigned int*)(&local_addr));
  return local;
}

test_find_local( char* remote_addr) { 
  struct in_addr remote;
  inet_aton(remote_addr, &remote);
  struct in_addr local_addr = find_local_addr_(remote);
  printf("remote: %s local: %s\n", remote_addr,
	 inet_ntoa( local_addr)
	 );
}

test_find_local_all() {
  test_find_local("10.0.3.3");
  test_find_local("143.4.3.1");
  test_find_local("0.0.0.0");
  test_find_local("127.0.0.1");
  test_find_local("192.168.0.1");
}

// ----------- DNS lookup -------------------------

// returns 0 on failure
unsigned int c_dns_lookup(const char * hostname) {
  struct hostent * server = gethostbyname(hostname);
  if (server == NULL) return 0;
  unsigned int addr = *((unsigned int*)(server->h_addr));
  return ntohl(addr);
}
