/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define _REENTRANT

#include <stdlib.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <net/if.h>

#include <unistd.h>
#include <string.h>
#include <sys/uio.h>

int in_cksum_seg(unsigned short * addr, int len, int index, int initial_sum)
{
  register int sum = initial_sum;
  register u_short *w = addr;
  register int nleft = len;
  u_short answer;
  
  if (nleft==0) return 0;
	
  if ((index & 1)==1) {
    answer = 0;
    *(u_char *)(&answer) = *(u_char *)w ;
    answer = answer << 8;
    sum += answer;
    nleft --;
  }

  while (nleft > 1)  {
    sum += *w++;
    nleft -= 2;
  }

  if (nleft == 1) {
    answer = 0;
    *(u_char *)(&answer) = *(u_char *)w ;
    sum += answer;
  }
  return sum;
}

unsigned short get_checksum( int sum) {
  /* add back carry outs from top 16 bits to low 16 bits */
  sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
  sum += (sum >> 16);                     /* add carry */
  unsigned short answer = ~sum;                          /* truncate to 16 bits */
  return(answer);
}

struct psuedohdr  {
  struct in_addr source_address;
  struct in_addr dest_address;
  unsigned char place_holder;
  unsigned char protocol;
  unsigned short length;
} psuedohdr;

int sockd;

//
// pre-condition:
// vec[0] must contain exactly the IP header and the TCP header
// vec[1..vec_count-1] contain the actual data to be sent
// totallen must be equal to the total size of vec
int sendpacket( struct iovec* vec,
		int vec_count,
		int iphlen,
		int tcphlen,
		int totallen
		)
{
  // some checks to make sure that the input is valid
  // assert(vec[0].iov_len == iphlen+tcphlen);
  // int j, total;
  // for (j=0, total=0; j<vec_count; j++)
  //   total += vec[j].iov_len;
  // assert(total == totallen);
  //printf("%d %d\n", vec_count, totallen);
  // --------------- IP HEADER ---------------------------------
  struct iphdr *iphdr = (struct iphdr *)(vec[0].iov_base);
  // these are auto-filled in
  iphdr->tot_len = 0;
  iphdr-> id = 0;
  iphdr-> check = 0;
  // compute IP checksum
  // assert(sizeof(struct iphdr) == iphlen);
  // iphdr->check = (unsigned short)in_cksum((unsigned short *)iphdr,iphlen,0);

  // --------------- TCP HEADER ---------------------------------
  struct tcphdr *tcph = (struct tcphdr *)( ((char*) iphdr) + iphlen);
  struct in_addr saddr,daddr;
  saddr.s_addr = iphdr->saddr;
  daddr.s_addr = iphdr->daddr;
  // compute TCP checksum
  assert(sizeof(struct tcphdr) == tcphlen);
  psuedohdr.protocol = IPPROTO_TCP;
  psuedohdr.length = htons(totallen-iphlen);
  psuedohdr.place_holder = 0;
  psuedohdr.source_address = saddr;
  psuedohdr.dest_address = daddr;
  int sum = 0;
  int index = 0;
  // check the pseudo header
  sum = in_cksum_seg( (unsigned short*) &psuedohdr,
		      sizeof(psuedohdr),
		      index,
		      sum
		      );
  index += sizeof(psuedohdr);
  // check the TCP header
  sum = in_cksum_seg( (unsigned short*) tcph,
		      tcphlen,
		      index,
		      sum
		      );
  index += tcphlen;
  // check the rest of the data
  int i;
  for (i=1; i<vec_count; i++) {
    sum = in_cksum_seg( (unsigned short*) (vec[i].iov_base),
			vec[i].iov_len,
			index,
			sum
			);
    index += vec[i].iov_len;
  }
  // finally get the checksum
  tcph->check = get_checksum(sum);

  // --------- SEND IP DATAGRAM ----------------------------------------
  struct sockaddr_in myaddr;
  memset(&myaddr,'\0',sizeof(myaddr));
  myaddr.sin_family = AF_INET;
  myaddr.sin_port = tcph->dest;
  myaddr.sin_addr = daddr;  
  struct msghdr msg;
  memset(&msg,'\0',sizeof(msg));
  msg.msg_name = &myaddr;
  msg.msg_namelen = sizeof(myaddr);
  msg.msg_iov = vec;
  msg.msg_iovlen = vec_count;

  int res = sendmsg(sockd, &msg, MSG_DONTWAIT);
  if (res != totallen) perror("sendto");
  return res;
}

int initrawsocket(void) {
  int on = 1;
  //printf("psuedohdr size = %d\n", sizeof(psuedohdr));
  if((sockd = socket(AF_INET,SOCK_RAW,IPPROTO_RAW)) < 0)  {
    perror("socket");
    exit(1);
  }
  
  if(setsockopt(sockd,IPPROTO_IP,IP_HDRINCL,(char *)&on,sizeof(on)) < 0)  {
    perror("setsockopt");
    exit(1);
  }
  return 0;
}

int getsendhandle() {
  return sockd;
}

int test_send_handle_writable() {
  int rc;
  fd_set fds;
  struct timeval tv;

  FD_ZERO(&fds);
  FD_SET(sockd,&fds);
  tv.tv_sec = tv.tv_usec = 0;
  rc = select(sockd+1,NULL,&fds,NULL,&tv);
  return FD_ISSET(sockd,&fds) ? 1 : 0;
}

