/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include <unistd.h>
#include <string.h>

#include <linux/netfilter.h>
#include <libipq/libipq.h>

#include <sys/time.h>

#define BUFSIZE 2000

struct ipq_handle *h;

int initipqueue(void) {
  struct timeval now;
  assert (sizeof(now.tv_sec)==4 && sizeof(now.tv_usec)==4);
  assert (sizeof(long long)==8);

  int status;
  h = ipq_create_handle(0, PF_INET);
  if (!h) {
    ipq_perror("ipq_create_handle");
    exit(1);
  }

  status = ipq_set_mode(h, IPQ_COPY_PACKET, BUFSIZE);
  if (status < 0) {
    ipq_perror("ipq_set_mode");
    exit(1);
  }
  return 0;
}

int getrecvhandle() {
  return h->fd;
}

int test_recv_handle_readable() {
  int rc;
  fd_set fds;
  struct timeval tv;

  FD_ZERO(&fds);
  FD_SET(h->fd,&fds);
  tv.tv_sec = tv.tv_usec = 0;
  rc = select((h->fd)+1,&fds,NULL,NULL,&tv);
  return FD_ISSET(h->fd,&fds) ? 1 : 0;
}


int recvpacket( unsigned char * p )
{
  int status;
        
  status = ipq_read(h, p, 2000, 0);
  if (status < 0 ) {
    ipq_perror("ipq_read");
    return 0;
  }

  switch (ipq_message_type(p)) {
  case NLMSG_ERROR:
    fprintf(stderr, "Received error message %d\n", ipq_get_msgerr(p));
    return 0;

  case IPQM_PACKET: {
    ipq_packet_msg_t *m = ipq_get_packet(p);
    //memcpy(p, m->payload, m->data_len);
    //printf("buf=%p msg=%p payload=%p\n", p, m, m->payload);
    status = ipq_set_verdict(h, m->packet_id, NF_DROP, 0, NULL);
    if (status < 0) {
      ipq_perror("ipq_set_verdict");
      exit(1);
    }
    return ( (unsigned char *)(m->payload) - p );
  }
    
  default:
    fprintf(stderr, "ipq_message_type: Unknown message type!\n");
    exit(1);
    break;
  }
  return 0;
}

/*
sudo modprobe iptable_filter
sudo modprobe ip_queue
sudo iptables -A INPUT -p TCP --dport 8888 -j QUEUE

*/
