/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define _REENTRANT
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#define BACKLOG 65500

void set_nonblocking(int fd)
{
    int flags;
    /* If they have O_NONBLOCK, use the Posix way to do it */
    if (-1 == (flags = fcntl(fd, F_GETFL, 0))) flags = 0;
    int res = fcntl(fd, F_SETFL, flags | O_NONBLOCK);
    assert(res==0);
}     

int c_sock_listen(int port) {
  int sockfd, newsockfd, portno, clilen, res;
  struct sockaddr_in serv_addr;
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  assert(sockfd>0);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(port);
  res = bind(sockfd, (struct sockaddr *) &serv_addr, 
                 sizeof(serv_addr));
  if (res<0) {
    fprintf(stderr, "bind error\n");
    return -1;
  }
  res = listen(sockfd,BACKLOG);
  if (res<0) {
    fprintf(stderr, "listen error\n");
    return -1;
  }
  set_nonblocking(sockfd);
  return sockfd;
}

int c_sock_accept(int server_fd) {
  int fd = accept(server_fd, NULL, NULL);
  if (fd == -1 && ( errno == EAGAIN || errno == EWOULDBLOCK) ) return -2;
  if (fd > 0) {
    set_nonblocking(fd);
    return fd; 
  } else {
    return -1;
  }
}

int c_sock_connect(unsigned int server_addr, int port) {
  // printf("c_sock_connect %s %d\n", server_addr, port);
  int sockfd, newsockfd, portno, clilen, res;
  unsigned int netaddr = htonl(server_addr);
  struct sockaddr_in serv_addr;
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  assert (sockfd > 0);
  serv_addr.sin_family = AF_INET;
  bcopy(&netaddr, &(serv_addr.sin_addr.s_addr), 4);
  serv_addr.sin_port = htons(port);
  set_nonblocking(sockfd);
  res = connect(sockfd,(const struct sockaddr*) &serv_addr,sizeof(serv_addr));
  if (res==0 || errno == EINPROGRESS)
    return sockfd;
  else
    return -1;
}


int c_sock_read(int fd, void* buf, int count) {
  int res = read(fd, buf, count);
  if (res >=0) return res;
  if (errno == EAGAIN) return -2;
  else return -1;
}

int c_sock_write(int fd, void* buf, int count) {
  //printf("[%d] c_sock_write begin, count=%d\n", fd, count);
  int res = write(fd, buf, count);
  //printf("[%d] c_sock_write end, res=%d\n", fd, res);
  if (res >=0) return res;
  if (errno == EAGAIN) return -2;
  return -1;  
}

int c_close(int fd) {
  return close(fd);
}

long long c_pipe_create () {
  long long tmp;
  int * p = (void*) & tmp;
  int res = pipe(p);
  set_nonblocking(*p);
  set_nonblocking(*(p+1));
  assert(res >=0);
  return tmp;
}
