/*
 * CBGC PU17 ccc header
 */


#include "target.h"
#include <varargs.h>
#include <string.h>

/* Bit values within flagvec */
#define m_static 1
#define m_register 2
#define m_unsigned 4
#define m_volatile 8
#define m_extern 16
#define m_isafun 32
#define m_const  64
#define m_signed 128

#define uchar unsigned char
#define NEWZ(X) ((X *) zmalloc(sizeof(X)))

extern void bcopy();
extern void bzero();


#define s_newid	 128
#define s_auto	 129
#define s_break	 130
#define s_case	 131
#define s_char	 132
#define s_const	 133
#define s_continue	 134
#define s_double	 135
#define s_do	 136
#define s_leaf	 137
#define s_default	 138
#define s_else	 139
#define s_extern	 140
#define s_for	 141
#define s_int	 142
#define s_goto	 143
#define s_if	 144
#define s_long	 145
#define s_register	 146
#define s_return	 147
#define s_short	 148
#define s_sizeof	 149
#define s_static	 150
#define s_struct	 151
#define s_switch	 152
#define s_typedef	 153
#define s_void	 154
#define s_while	 155
#define s_union	 156
#define s_volatile	 157
#define s_unsigned	 158
#define s_signed         159
#define s_commentstart	 160
#define s_eof	 161
#define s_commentend	 162
#define s_number	 163
#define s_lsect	 '{'
#define s_rsect	 '}'
#define s_lparen	 '('
#define s_rparen	 ')'
#define s_lsquare	 '['
#define s_rsquare	 ']'
#define s_dot	 '.'
#define s_comma	 ','
#define s_semicolon	 ';'
#define s_percent	 '%'
#define s_colon	 ':'
#define s_query	 '?'

#define s_plus	 '+'
#define s_plusplus	 170
#define s_pluseq	 171
#define s_minus	 '-'
#define s_minusminus	 172
#define s_minuseq	 173
#define s_ampersand	 '&'
#define s_logand	 174
#define s_andeq	 175
#define s_bitor	 '|'
#define s_logor	 176
#define s_oreq	 177
#define s_equals	 '='
#define s_eqeq	 178
#define s_pling	 '!'
#define s_plingeq	 179
#define s_greater	 '>'
#define s_greatereq	 180
#define s_rshift	 181
#define s_lesser	 '<'
#define s_lessereq	 182
#define s_lshift	 183
#define s_arrow	         184
#define s_slash	 '/'
#define s_slasheq	 185
#define s_star	 '*'
#define s_stareq	 186
#define s_string	 187
#define s_eor	 188
#define s_coloneq	 189
#define s_3dots	 190
#define s_define	 191
#define s_macro 	 192
#define s_tilda          '~'
#define s_lshifteq       193
#define s_rshifteq       194
#define s_bit            195
#define s_abs            196
#define s_eoreq          197
#define s_enum           198


#define e_number            10
#define e_id                11 
#define e_string            12
#define e_cast              13
#define e_stars             14 
#define e_tilda             15
#define e_pling             16 
#define e_minus_not_used    17
#define e_pre_plusplus      18 
#define e_pre_minusminus    19
#define e_addressof         20
#define e_cmd               21
#define e_query             22
#define e_assign            23
#define e_bitor             24
#define e_eor               25
#define e_bitand            26
#define e_comparisonip      27
#define e_rshift            28
#define e_lshift            29
#define e_add               30
#define e_subtract          31
#define e_multiply          32 
#define e_divide            33
#define e_remainder         34
#define e_call              36
#define e_post_plusplus     37
#define e_post_minusminus   38
#define e_arrow             39
#define e_dot               40
#define e_logor             41
#define e_logand            42
#define e_actualarg         43
#define e_abs               44


#define p_eval      2
#define p_label     3
#define p_block     4 
#define p_return    5 
#define p_do        6
#define p_break     7
#define p_continue  8
#define p_while     9
#define p_if        10
#define p_goto      11
#define p_for       12
#define p_switch    13
#define p_decl      14
#define p_formal    15
#define p_srctext   16
#define p_3dots     17

typedef struct enode_s 
{ 
  struct enode_s *exp, *exp1, *exp2;
  char *wordnode;
  uchar uch;
  int i, stars, key;
  struct instance_s *it;
} ENODE;


/* 68k: #define target_stackohead	 8;   old frame and rla */

/* 
 * values of cpath
 */
#define sim_lval	 1
#define sim_rval	 2
#define sim_local_stack	 3
#define num_rval	 4  /* Source numeric #define constans */
#define sim_local_reg	 5
#define sim_enum         6  /* enumeration type member */

typedef struct typelist {
  int tptr, tstars;
  struct typelist *tnext;
} TYPELIST;


/*
 * ? Startstars is copied out to stars1 ?
 * ctsize will be set as per st->size if st exists 
 */ 
typedef struct ct_s
{
  struct structure_s *st;
  int ctsize, startstars; 
} CT;


#define MAXDIMS 5 /* Max dimensions to an array */

typedef struct instance_s 
{ 
  int stars1, stars2, flagvec; 
  char *wnode; 
  int dimensions, dim_idx[MAXDIMS];
  struct ct_s *ct;
} INSTANCE;


/*
 * main symbol table item
 */
typedef struct christ 
{
  char * cname;
  int cpath, idx;
  struct christ * cnext;
  struct typelist *argtypes;
  struct instance_s *it;
} CHRIST;

typedef struct routine_s
{
  struct pt_s * formals, *body;
  char *name;
  struct cons_s *callees;
  struct routine_s *next;
  int argcount, argbase;
  int checkedf;
  struct instance_s *it;
} ROUTINE;

/* expression
 */
typedef struct expression 
{
  int epathhi, epathlo, einds;
  union { char *s; int i; struct lititem *lit; } evalue;
  struct instance_s *it;
  int unmodifiablef;
} EXPRESSION;


/* values of epathhi
 */
#define e_value	         0
#define e_register	 2
#define e_flags	         3
#define e_badpath	 4
#define e_flags_unsigned 5


/*
 * values of epathlo
 */
#define el_numeric	 1
#define el_symbolic	 2
#define el_label	 3
#define el_litpool       4





/* struture/union table entry
 */
typedef struct structure_s {
  char * sname;
  int totalsize;
  struct stag *staglist;
  struct structure_s *nextstruct;
} STRUCT;

/* 
 * tag information - for things in a struct or union
 */
typedef struct stag 
{
  char * tagname;
  int tpartial, tagindex;
  INSTANCE *it;
  struct stag * nextstag;
} STAG;

/* 
 * pool of literal strings and expressions
 */
typedef struct lititem {
  struct cons_s *slist;
  struct lititem *lnext;
  int lindex;
  EXPRESSION *e;
} LITITEM;


typedef char *CAR_T;

typedef struct cons_s 
{ 
  CAR_T car; 
  struct cons_s * cdr; 
  int n;
} CONS;

typedef struct pt_s
{
  int key;
  struct pt_s *c1, *c2, *c3;
  struct enode_s *e1, *e2;
  char *wordnode;
  struct instance_s *instance;
 
} PT;


typedef struct type 
{ 
  CT *ct; int stars, flags;  char *name; struct type *tnext; 
} TYPE;

extern struct lititem *litpoollist;
extern void banner();

/*
 * cpp
 */
extern void hashdefine(char *name);
extern void hashdefstr(char *x, char *q);


/*
 * Interface to lexical analyser.
 */
extern char *lextok(int i);
extern CONS *srcptr;
extern unsigned char symb, nextsymb();
extern char tagbuffer[];
extern char *wordnode;
extern int linenumber;
extern void lexinit(char * s);
extern void errorline();
extern void unnextsymb();

/* 
 * ccc
 */
extern void breakpoint();
extern int usr_dirs, sys_dirs;
extern int im_flag;
extern char *default_usr_dirs[], *default_sys_dirs[];
extern char *error_src_string;
extern int verbosef;
extern void staticval1(int flags, CT *ct, int value);
extern void staticval(CT *ct, int value);
extern void staticvalench(CT *, EXPRESSION *);
extern int snesting;
extern void debugleader(char *s);
extern void bss_mkglobext2(int flags, char *s);
extern void text_mkglobext2(int flags, char *s);
extern void ramreserve1(int flags, int size, int noff);
extern int errorflag;
extern CHRIST *christen(char *name, int path, INSTANCE *it, int value, int maskallowed);
extern void printct(CT *);
extern CT *ct_char, *ct_generic, *ct_int, *ct_label, *ct_void, *ct_ptr;
extern int flagsvalid;
extern int flowing;
extern void error();
extern void fatal();
extern void checkfor(uchar);
extern void local_vars();
extern struct stag *findtag();
extern char *zmalloc(int);
/* 
 * compile
 */
extern ROUTINE *routines;
extern int compile_map(int (*f)(), int dontstopf, PT *p);
extern void compile1(char *fname);


extern int compile_fcondition(ENODE *, int, int sp);
extern int compile_tcondition(ENODE *, int, int sp);
extern int compile_fjump(ENODE *, int, int sp);
int compile_tjump(ENODE *, int, int sp);
extern void compile_evalcmd(ENODE *e);
extern void compile_command(PT *c, int sp, int leaff);
extern EXPRESSION *compile_eval(ENODE *e);
extern EXPRESSION *compile_expr_for_gotos(ENODE *e, int sp);
extern void set_local_var_mode(EXPRESSION *e, struct christ *c);
extern int evalmanifeste(ENODE *);
extern EXPRESSION *compile_evalconst(ENODE *);
extern EXPRESSION *eval_for_gotos(ENODE *);
extern EXPRESSION *manifestint();
extern EXPRESSION *evaltod0();
extern void evalcmd();
extern EXPRESSION *compile_expr(ENODE *e, int sp);

/*
 * parser
 */
extern INSTANCE *copyit(INSTANCE *);
extern void startlev1();
extern void parser_clear();
extern char *current_routine;
extern INSTANCE *parse_instance(int, int flagvec, CT* ct, int star0);
extern ENODE *parse_expr();
extern CONS *cons(CAR_T a, CONS *b);
extern CONS *cons_with_n(CAR_T a, CONS *b, int n);
extern INSTANCE *readinstance();
extern void compileblock();


extern struct christ *  clookup();
extern CT *ct_insize(int *, int *);
extern int aflag;

/*
 * arith
 */
extern void force(EXPRESSION *ex, int reg, char *name);
extern void code_generate_scanner(int defaultvec, int cases, int tagpoolvec, int vecpoolvec, int exprreg, int size);
extern void code_moveri(EXPRESSION *lhs, EXPRESSION *rhs, char *t, int nodreff);
extern EXPRESSION *gen_arith(uchar op, EXPRESSION *lhs, EXPRESSION *rhs, char adr);
extern EXPRESSION *indexscale(uchar op, EXPRESSION *base, EXPRESSION *index);
extern int pointedsize(EXPRESSION *e);
extern EXPRESSION *arith_negate(EXPRESSION *ex);
extern EXPRESSION *logical_negate(EXPRESSION *ex);
extern void copy_etype_info(EXPRESSION *, EXPRESSION *);
extern EXPRESSION *arith_abs(EXPRESSION *ex);
extern EXPRESSION *arith_complement(int size, EXPRESSION *ex);
extern EXPRESSION *force_loadto(EXPRESSION *e, int regtype);
extern EXPRESSION *fpexp(FILE *jcos, EXPRESSION *ex);
EXPRESSION *gloadto(EXPRESSION *e);
EXPRESSION *reduce_indsof(EXPRESSION *e);
/* code
 */
extern int colour();
extern void clear_code();
extern void dump_code();
extern void seg_select(int);
extern void fprint_it(FILE *, INSTANCE *);
extern EXPRESSION *loadto_given_dreg(EXPRESSION *ex, int r0);
extern void quick_add_sub(char op, int size, EXPRESSION *e, int delta);
extern EXPRESSION *quick_add_sub_pre(char op, int size, EXPRESSION *e, int delta);
extern EXPRESSION *quick_add_sub_post(char op, int size, EXPRESSION *e, int delta);
extern void bss_ds_bytes(int);
extern int reg_free_slots();
extern EXPRESSION *pexp(EXPRESSION *, char *id);
extern EXPRESSION *getflagsv(EXPRESSION * ex);
extern EXPRESSION *nexp(EXPRESSION *);
extern int label(int);
extern int ujump(int);
extern uid();
int reserve(int);
void data_output();
extern void code_goto();
extern void ocode();
extern void assembly();
extern EXPRESSION *code_callv(EXPRESSION *, int);
extern void code_entry(int, int);
extern void code_return();
extern int pathsize();
extern struct lititem *litpooladd(CONS *c, int labelindex);
extern void litpooldump();
extern void staticstring();
EXPRESSION *loadtodreg(EXPRESSION *ex);
extern void force_loadtod0(EXPRESSION *ex);

/* slaving
 */
extern int  saveexp();
extern void killval(EXPRESSION *);
extern EXPRESSION *getexp();
extern EXPRESSION *makedalt(EXPRESSION *ex);
extern int newdreg();
extern void restore_runsp(int);
extern void save_or_restore_mcstate(int);
extern EXPRESSION *copyofexp();
extern void swapvals();
extern int restricted_mode;

/* extern void pexp(EXPRESSION *e); */
extern EXPRESSION *make_ldst_mode(EXPRESSION *);
extern EXPRESSION *make_vaoid_mode(EXPRESSION *);
extern EXPRESSION *rmult();
extern EXPRESSION *rdiv();
extern EXPRESSION *new_rpolish(int key, EXPRESSION *lhs, EXPRESSION *rhs, char adr);
extern EXPRESSION *loadasint();
extern EXPRESSION *blank_reg(INSTANCE *it);
extern EXPRESSION *assign(EXPRESSION *lhs, EXPRESSION *rhs);
extern EXPRESSION *assigncoerce(EXPRESSION *rhs, CT *ct, int stars);
extern int pimzero();
extern int pimrhs();



#define o_addi 2
#define o_lodi 1
#define o_rsbi 3
#define o_load 4  /* ban */
#define o_store  5 /* ban */
#define o_add 6
#define o_sub 7
#define o_mov 8
#define o_subi 9
#define o_andi 10
#define o_eor 11
#define o_tsti 12
#define o_lsr1 13
#define o_lsl1 14
#define o_asr1 15
#define o_msg 16
#define o_msg1 17
#define o_msg2 18
#define o_code 19
#define o_code1 20
#define o_code2 21
#define o_ujump 22
#define o_bne 23
#define o_beq 24
#define o_asl1 25
#define o_cmp 26
#define o_loadsymb 27
#define o_or 28
#define o_error 29
#define o_label 30
#define o_cmpi 31
#define o_and      32
#define o_hard     33
#define o_lodisymb 34
#define o_lodilab  35
#define o_loadsf   36
#define o_storesf  37
#define o_storesymb 38
#define o_eori     39
#define o_ori      40
#define o_storeabs 41
#define o_bxl      42
#define o_labl1    43
#define o_addsf    44
#define o_subsf    45
#define o_bx       46
#define o_code2reg 47
#define o_code0reg 48
#define o_code2reg2 49
#define o_code0reg2 50


#define O_BSS 1
#define O_TEXT 2

/* End of ccchdr.h */
