

 
/* cbgc Closure C compiler 
 *
 *
 * (C) 1990-95 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */


/* define CTRACE */
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include "ccchdr.h"
#define text_output assembly
#define MAXERRORS 7  /* Max errors to print from one file */


char banner_text[] = BANNER_TEXT;

char *default_sys_dirs[50];
int sys_dirs = 0;

char *default_usr_dirs[50];
int usr_dirs = 0;


/* 
 *Local file prototypes 
 */







/* 
 * global variables 
 */
CHRIST *genv;

int flowing; /* whether program is under flow */
int runsp;
int runf;
int verbosef = 0;
int nostdinc_flag = 0;
int im_flag = 0;
int romf;
int nobssf;
int instars;
int errorflag = 0;
int snesting;
int warnings;
int dnaflag;
int flagsvalid;
int ansi;
int restricted_mode = 0;  /* Use reduced instruction set flag */
extern char *buffer1;
char *progname;
char *srcname;
int dontdel;
FILE * sysout;  /* object file descriptor */
extern int errors, eflag;
int aflag;
struct expression *ex, *apex;
extern char *error_src_string;

static char * objname;

CT *ct_int, *ct_label, *ct_generic, *ct_void, *ct_ptr, *ct_char;

extern void starname();
extern void cppinit();
extern void compile(char *);
extern int cpprun();

int main(argc, argv) char **argv;
{ 
  /* CBG closure C compiler */

  progname = argv[0];
  ex = malloc(sizeof(struct expression));
  apex = malloc(sizeof(struct expression));
  cppinit();
  ansi = 0;
  snesting = 0;
  dontdel = 0;
  aflag = 0;
  nobssf = 0;
  dnaflag = 0;
  eflag = 0;
  romf = 0;

  ct_label = NEWZ(CT); /* No values in this ct */
  ct_void = NEWZ(CT);  /* No values in void either */
  ct_int  = NEWZ(CT);  
  ct_generic  = NEWZ(CT);  
  ct_generic->ctsize = target_int_size;
  ct_int->ctsize = target_int_size;
  ct_ptr = NEWZ(CT);
  ct_ptr->ctsize = target_ptr_size;
  ct_char = NEWZ(CT);
  ct_char->ctsize = 1;
  
  if (argc == 1)
  {
    printf("ccomp usenix: cc [-I<dir> -I-  -nostdinc -dontdel -ansi -A -E -68k -dna -rom ] f1 f2 ...\n");
    exit(1);
  }
  argc--; argv++;
  while(1)
  {
    if (strcmp(*argv, "-dontdel")==0)
    {
      argc--; argv++;
      dontdel = 1;
      continue;
    }
    if (strcmp(*argv, "-c")==0)
    {
      argc--; argv++;
      /* This is always done */
      continue;
    }
    if (strcmp(*argv, "-rom")==0)
    {
      argc--; argv++;
      romf = 1;
      continue;
    }

    if (strcmp(*argv, "-bss")==0)
    {
      argc--; argv++;
      nobssf = 0;
      continue;
    }

    if (strcmp(*argv, "-nobss")==0)
    {
      argc--; argv++;
      nobssf = 1;
      continue;
    }

    if (strcmp(*argv, "-dna")==0)
    {
      argc--; argv++;
      dnaflag = 1;
      continue;
    }

    if (strcmp(*argv, "-E")==0)
    {
      argc--; argv++;
      eflag = 1;
      continue;
    }

    if (strncmp(*argv, "-I", 2)==0)
    {
      char linep[132];
      char *p = *argv;
      int i = 0;


      if (strncmp(*argv, "-I-", 3)==0)
	{
	  argc--; argv++;
	  im_flag = 1;
	  continue;
	}


      p+=2;
      while (*p)
	{
	  while(*p && *p !=':' && *p != ' ') linep[i++] = *p++;
	  linep[i] = 0;

	  default_usr_dirs[usr_dirs++] = strdup(linep);
	  if (im_flag) default_sys_dirs[sys_dirs++] = strdup(linep);
	  if (*p == ':') p++;
	  i = 0;
	}

      argc--; argv++;
      
      continue;
    }

    if (strcmp(*argv, "-nostdinc")==0)
    {
      argc--; argv++;
      nostdinc_flag = 1;
      continue;
    }

    if (strcmp(*argv, "-68k")==0)
    {
      argc--; argv++;
      restricted_mode = 1;
      continue;
    }

    if (strcmp(*argv, "-verbose")==0)
    {
      argc--; argv++;
      verbosef = 1;
      continue;
    }

   if (strcmp(*argv, "-A")==0)
    {
      argc--; argv++;
      aflag = 1;
      continue;
    }

   if (strcmp(*argv, "-ansi")==0)
    {
      argc--; argv++;
      ansi = 1;
      continue;
    }

   if (strncmp(*argv, "-D",2)==0)
    {
      hashdefstr(*argv+2, "");
      argc--; argv++;
      continue;
    }

    if (argv[0][0] == '-')
      {
	printf("Ignore command line flag %s\n", argv[0]);
	argc --;
	argv ++;
	continue;
      }
    else     break;
  }

  if (nostdinc_flag == 0) default_sys_dirs[sys_dirs++] = "/usr/include";
  if (im_flag == 0) default_usr_dirs[usr_dirs++] = ".";

  /* printf("Compiling %i files\n", argc); */
  while(argc > 0)
  {
    /* printf("Reading %s\n", *argv); */

     compile(*argv);
     if (errors) return errors;
     argv++; argc--;
   }
  return 0;
}

void tidyup()
{
  if (sysout != stdout) fclose(sysout);
  if (errors && dontdel == 0) remove(objname);
}


void compile(char * f)
{
  
  int len = strlen(f)+1;
  int dumpmacs = 0;
  
  objname = malloc(len);
  srcname = strdup(f);
  if(cpprun(f, dumpmacs)) return;

  if (eflag)  /* -E is to just list preproccesed output */
  {
    extern int write(int, char *, int);
    write(fileno(stdout), buffer1, strlen(buffer1));
    return;
  }

  errors = 0;
  warnings = 0;
  snesting = 0;

 /* Generate .s file name */
  strcpy (objname, f);
  objname[strlen(objname)-1] = 's';

  if (aflag) sysout = stdout;
  else
  {
    sysout = fopen(objname, "w");
    if (sysout == 0)
    { 
      perror("cant open .o file");
      exit(1);
    }
  }

  compile1(f);
  tidyup();
  if (errors)
     printf("Errors = %i compiling %s\n", errors, f);
#if 0
  else if (dnaflag == 0)
    {
      static  char *asv[4];
      asv[0] = "/bin/as";
      strcpy (srcname, f);
      strcpy (objname, f);
      srcname[strlen(objname)-1] = 's';
      objname[strlen(objname)-1] = 'o';
      asv[1] = srcname;
      asv[2] = objname;
      asv[3] = 0;
      rc = execv(asv[0], asv);
    rc = jt_join(rc);
    if (rc) return (rc);
    remove(srcname);
  }
#endif
}



void staticval1(int flagvec, CT *ct, int value)
{ 
  if ((flagvec & m_extern) == 0) 
    if (ct->ctsize == 1) assembly("DAT\t .defb !i\n", value);
  else if (ct->ctsize == 4) assembly("DAT\t .defw !i\n", value);
  else error("bad size in staticval");
}

void staticvalench(CT *ct, struct expression *xx)
{
  if (xx->epathhi != e_value) error("Non constant static initialiser");
  assembly("DAT\t %s !V\n", (ct->ctsize == 1)? ".defb": ".defw", xx->epathlo, xx->evalue);
  killval(xx);
}


void bss_mkglobext2(int flagvec, char *s)
{
  if ((flagvec & m_extern)) assembly("BSS;_!s\t .extern\n", s);
  else 
  {
    if ((flagvec & m_static) == 0) assembly("BSS_!s\t .global\n", s);
    else assembly("BSS_!s\n", s);
  }
}

void text_mkglobext2(int flagvec, char *s)
{
  if ((flagvec & m_extern)) text_output("; _!s\t .extern\n", s);
  else 
  {
    if ((flagvec & m_static) == 0) text_output("_!s\t .global\n", s);
    else text_output("_!s\n", s);
  }
}

void ramreserve1(int flagvec, int size, int noff)
{
  if (size == 4) assembly("BSS\t .align 4\n", "");
  if (size > 4)
  {
    noff = ((noff * size) + 3) & 0xFFFFFFFC;
    size = 1;
  }
  if ((flagvec & m_extern) == 0) bss_ds_bytes(noff * size);

}


void banner()
{
  static int bannerf = 1;
  if (bannerf) printf("CBG CC %s\n", banner_text);
  bannerf = 0;
}

void breakpoint()
{
 ;
}


/* >error 
 * compile.c:998: warning: passing arg 1 of `manifestint' makes integer from pointer without a cast
 */
void error(s, p, q, r) char *s;
{
  int wf = (*s == 'w');
  banner();
  if (!errorflag)
    {
      if (error_src_string) printf("%s\n", error_src_string);
      printf("%s:%i: %s: in routine '%s' ", srcname, linenumber, (wf) ? "warning":"error", current_routine);
      printf(s, p, q, r);
      printf("\n");
      errorline();
      breakpoint();
      assembly("; Error \n");
    }
  if (wf) warnings ++;
  else
  {
    errors++;
    errorflag = 1;
  }
  if (errors > MAXERRORS) fatal("Too many errors");
}

void fatal(s, p, q, r) char *s;
{
   printf("Fatal error '%s' line %i: ", current_routine, linenumber);
   printf(s, p, q, r);
   tidyup();
   exit(1);
}

void debugleader(char *s)
{
  seg_select(O_TEXT);
  if (leaders_in_text) assembly("\n\n\t .data '_!s'\n", s);
  else 
    {
      assembly("\n\n; Routine !s\n", s);
    }
}



char *zmalloc(int s)
{
  char *r = malloc(s);
  if (r == NULL)
    {
      printf("%s out of VM\n", progname);
      exit(0);
    }
  bzero(r, s);
  return r;
}
 
/* end of ccc.c */
