#include "../include/lynxq.h"
#include <stdio.h>
#include <stdlib.h>

#define QUEUE_SIZE (1<<21)	/* 2MB */

#define DATA ((1 << 30))
#define DATATYPE long


volatile long push_sum;
void *
push_f(void *arg)
{
  lynxQ_t queue1 = (lynxQ_t) arg;
  long i, sum = 0;

  for(i=0; i != DATA; i++) {
    queue_push_long(queue1, i);
    sum += i;
  }
  fprintf(stderr, "PUSH done. Sum=0x%lx\n", sum);
  push_sum = sum;
  queue_push_done (queue1);
  return NULL;
}

void *
pop_f(void *arg)
{
  lynxQ_t queue1 = (lynxQ_t) arg;
  long qval, i, sum = 0;

  for (i = 0; i != DATA; ++i) {
    qval = queue_pop_long(queue1);
    sum += qval;
  }
  queue_pop_done (queue1);
  printf ("POP done.  Sum=0x%lx\n", sum);
  if (sum != push_sum) {
    fprintf (stderr, "\n\nERROR: sum != 0x%lx\n", push_sum);
  } else {
    fprintf (stderr, "SUCCESS!\n");
  }
  return NULL;
}

static void start_thread_and_pin (pthread_t *thread, void * (*func)(void *),
				  void *arg, int core) {
  cpu_set_t mask;
  CPU_ZERO(&mask);
  CPU_SET(core, &mask);
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setaffinity_np(&attr, sizeof(cpu_set_t), &mask);
  pthread_create(thread, &attr, func, arg);
}

static void join_thread (pthread_t *thread, void **value_ptr, const char *msg) {
  pthread_join(*thread, value_ptr);
  fprintf (stderr, "%s", msg);
}

int
main(int argc, char **argv)
{
  pthread_t push_thread, pop_thread;

  // lynxQ_t queue1 = queue_init (QUEUE_SIZE, &push_thread, &pop_thread);
  lynxQ_t queue1 = queue_init (QUEUE_SIZE);

  /* Start push thread and pin it to core 1 */
  start_thread_and_pin(&push_thread, (void *(*) (void *)) &push_f, (void *) queue1, 1);

  /* Busy wait until pop thread is ready to start */
  queue_busy_wait_pop_ready(queue1);

  /* Start pop thread and pin it to core 3 */
  start_thread_and_pin(&pop_thread, (void *(*) (void *)) &pop_f, (void *) queue1, 3);

  /* Join threads */
  join_thread(&push_thread, NULL, "** PUSH THREAD JOINED\n");
  join_thread(&pop_thread, NULL, "** POP THREAD JOINED\n");
  queue_finalize(queue1);
  
  double time = queue_get_time(queue1);
  free (queue1);
  
  fprintf (stderr, "Queue Bandwidth: %10.4f GBytes/s\n",
	   ((double)DATA * sizeof(long))/(time * 1024 * 1024 * 1024));
  fprintf (stderr, "Total data sent: %10.4f GBytes\n",
	   ((double)DATA * sizeof(long))/(1024 * 1024 * 1024));
  
  return 0;
}
