/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.databases.moviedb.internal;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImportRelational {
    private final Connection hsql;
    private final Connection pg;
    private final String moviesTable;
    private final String peopleTable;

    public ImportRelational(Connection hsql, Connection pg, boolean onlyTopTitles) {
        this.hsql = hsql;
        this.pg = pg;
        if (onlyTopTitles) {
            this.moviesTable = "movies_doc_small";
            this.peopleTable = "people_doc_small";
        } else {
            this.moviesTable = "movies_doc";
            this.peopleTable = "people_doc";
        }
    }

    public void run() throws SQLException {
        this.copyMovies();
        this.copyPeople();
        this.copyCredits();
        this.copyCertificates();
        this.copyColorInfo();
        this.copyGenres();
        this.copyKeywords();
        this.copyLanguages();
        this.copyLocations();
        this.copyReleaseDates();
        this.copyRunningTimes();
        System.out.println("Compacting the database...");
        this.execHSQL("SHUTDOWN COMPACT");
    }

    private void copyMovies() throws SQLException {
        System.out.println("Copying movies...");
        this.execHSQL("CREATE CACHED TABLE movies (id integer PRIMARY KEY, title varchar(255) NOT NULL, year integer)");
        this.execHSQL("CREATE INDEX movies_title ON movies (title)");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO movies (id, title, year) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', properties->>'title', properties->>'year' FROM " + this.moviesTable);
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 4);
            }
        }
    }

    private void copyPeople() throws SQLException {
        System.out.println("Copying people...");
        this.execHSQL("CREATE CACHED TABLE people (id integer PRIMARY KEY, name varchar(255) NOT NULL, gender varchar(10))");
        this.execHSQL("CREATE INDEX people_name ON people (name)");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO people (id, name, gender) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', properties->>'name', properties->>'gender' FROM " + this.peopleTable);
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12);
            }
        }
    }

    private void copyCredits() throws SQLException {
        System.out.println("Copying credits...");
        this.execHSQL("CREATE CACHED TABLE credits (person_id integer NOT NULL REFERENCES people (id), movie_id integer NOT NULL REFERENCES movies (id), type varchar(20) NOT NULL, note varchar(255), character varchar(255), position integer, line_order integer, group_order integer, subgroup_order integer, UNIQUE (person_id, movie_id, type))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO credits (person_id, movie_id, type, note, character, position, line_order, group_order, subgroup_order) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT person_id, movie_id, type, credits.properties->>'note', credits.properties->>'character', credits.properties->>'position', credits.properties->>'line_order', credits.properties->>'group_order', credits.properties->>'subgroup_order' FROM credits JOIN " + this.moviesTable + " ON (" + this.moviesTable + ".properties->>'id')::integer = movie_id " + "WHERE type <> 'miscellaneous'");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 4, 12, 12, 12, 4, 4, 4, 4);
            }
        }
    }

    private void copyCertificates() throws SQLException {
        System.out.println("Copying certificates...");
        this.execHSQL("CREATE CACHED TABLE certificates (movie_id integer NOT NULL REFERENCES movies (id), country varchar(20) NOT NULL, certificate varchar(20) NOT NULL, note varchar(255))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO certificates (movie_id, country, certificate, note) values(?, ?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', cert->>'country', cert->>'certificate', cert->>'note' FROM " + this.moviesTable + ", jsonb_array_elements(properties->'certificates') AS cert");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12, 12);
            }
        }
    }

    private void copyColorInfo() throws SQLException {
        System.out.println("Copying color_info...");
        this.execHSQL("CREATE CACHED TABLE color_info (movie_id integer NOT NULL REFERENCES movies (id), value varchar(20) NOT NULL, note varchar(255))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO color_info (movie_id, value, note) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', color->>'color_info', color->>'note' FROM " + this.moviesTable + ", jsonb_array_elements(properties->'color_info') AS color");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12);
            }
        }
    }

    private void copyGenres() throws SQLException {
        System.out.println("Copying genres...");
        this.execHSQL("CREATE CACHED TABLE genres (movie_id integer NOT NULL REFERENCES movies (id), genre varchar(25) NOT NULL)");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO genres (movie_id, genre) values(?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id' AS movie_id, jsonb_array_elements_text(properties->'genres') FROM " + this.moviesTable);
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12);
            }
        }
    }

    private void copyKeywords() throws SQLException {
        System.out.println("Copying keywords...");
        this.execHSQL("CREATE CACHED TABLE keywords (movie_id integer NOT NULL REFERENCES movies (id), keyword varchar(127) NOT NULL)");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO keywords (movie_id, keyword) values(?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id' AS movie_id, jsonb_array_elements_text(properties->'keywords') FROM " + this.moviesTable);
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12);
            }
        }
    }

    private void copyLanguages() throws SQLException {
        System.out.println("Copying languages...");
        this.execHSQL("CREATE CACHED TABLE languages (movie_id integer NOT NULL REFERENCES movies (id), language varchar(35) NOT NULL, note varchar(255))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO languages (movie_id, language, note) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', language->>'language', language->>'note' FROM " + this.moviesTable + ", jsonb_array_elements(properties->'languages') AS language");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12);
            }
        }
    }

    private void copyLocations() throws SQLException {
        System.out.println("Copying locations...");
        this.execHSQL("CREATE CACHED TABLE locations (movie_id integer NOT NULL REFERENCES movies (id), location varchar(255) NOT NULL, note varchar(511))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO locations (movie_id, location, note) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', location->>'location', location->>'note' FROM " + this.moviesTable + ", jsonb_array_elements(properties->'locations') AS location");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12);
            }
        }
    }

    private void copyReleaseDates() throws SQLException {
        System.out.println("Copying release_dates...");
        this.execHSQL("CREATE CACHED TABLE release_dates (movie_id integer NOT NULL REFERENCES movies (id), country varchar(40) NOT NULL, release_date varchar(10) NOT NULL, note varchar(255))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO release_dates (movie_id, country, release_date, note) values(?, ?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT movie_id, country, date->>'release_date', date->>'note' FROM (SELECT movie_id, country, jsonb_array_elements(dates) AS date FROM (SELECT properties->>'id' AS movie_id, by_country.key AS country, by_country.value AS dates FROM " + this.moviesTable + ", jsonb_each(properties->'release_dates') AS by_country" + ") reldates) reldates2");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12, 12);
            }
        }
    }

    private void copyRunningTimes() throws SQLException {
        System.out.println("Copying running_times...");
        this.execHSQL("CREATE CACHED TABLE running_times (movie_id integer NOT NULL REFERENCES movies (id), running_time varchar(40) NOT NULL, note varchar(255))");
        try (PreparedStatement insert2 = this.hsql.prepareStatement("INSERT INTO running_times (movie_id, running_time, note) values(?, ?, ?)");
             Statement select2 = this.pg.createStatement();){
            ResultSet results = select2.executeQuery("SELECT properties->>'id', rtime->>'running_time', rtime->>'note' FROM " + this.moviesTable + ", jsonb_array_elements(properties->'running_times') AS rtime");
            while (results.next()) {
                this.copyRow(results, insert2, 4, 12, 12);
            }
        }
    }

    private void copyRow(ResultSet results, PreparedStatement insert2, int ... types2) throws SQLException {
        int paramIndex = 0;
        block4: for (int type : types2) {
            ++paramIndex;
            switch (type) {
                case 4: {
                    insert2.setInt(paramIndex, results.getInt(paramIndex));
                    if (!results.wasNull()) continue block4;
                    insert2.setNull(paramIndex, type);
                    continue block4;
                }
                case 12: {
                    insert2.setString(paramIndex, results.getString(paramIndex));
                    if (!results.wasNull()) continue block4;
                    insert2.setNull(paramIndex, type);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported SQL type: " + type);
                }
            }
        }
        insert2.execute();
    }

    private void execHSQL(String sql) throws SQLException {
        try (Statement statement = this.hsql.createStatement();){
            statement.executeQuery(sql);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2 || !args[0].equals("--large") && !args[0].equals("--small")) {
            System.err.println("Usage: ImportRelational [--large|--small] output-dir");
            System.exit(1);
        }
        File dbPath = new File(args[1], "moviedb");
        Class.forName("org.hsqldb.jdbc.JDBCDriver");
        Class.forName("org.postgresql.Driver");
        try (Connection hsql = DriverManager.getConnection("jdbc:hsqldb:file:" + dbPath + ";shutdown=true");
             Connection pg = DriverManager.getConnection("jdbc:postgresql:");){
            new ImportRelational(hsql, pg, args[0].equals("--small")).run();
        }
    }
}

