/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.databases.moviedb.internal;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.tooling.ImportTool;
import uk.ac.cam.cl.databases.moviedb.MovieDB;
import uk.ac.cam.cl.databases.moviedb.model.Certificate;
import uk.ac.cam.cl.databases.moviedb.model.ColorInfo;
import uk.ac.cam.cl.databases.moviedb.model.CreditActor;
import uk.ac.cam.cl.databases.moviedb.model.CreditPerson;
import uk.ac.cam.cl.databases.moviedb.model.CreditWriter;
import uk.ac.cam.cl.databases.moviedb.model.Language;
import uk.ac.cam.cl.databases.moviedb.model.Location;
import uk.ac.cam.cl.databases.moviedb.model.Movie;
import uk.ac.cam.cl.databases.moviedb.model.Person;
import uk.ac.cam.cl.databases.moviedb.model.ReleaseDate;
import uk.ac.cam.cl.databases.moviedb.model.RunningTime;

public class ImportGraph {
    private static Integer next_country_id = 1;
    private static Integer next_genre_id = 1;
    private static Integer next_keyword_id = 1;
    private static Integer next_language_id = 1;
    private static Integer next_location_id = 1;
    private static TreeMap<String, Integer> country_id_map = new TreeMap();
    private static TreeMap<String, Integer> genre_id_map = new TreeMap();
    private static TreeMap<String, Integer> keyword_id_map = new TreeMap();
    private static TreeMap<String, Integer> language_id_map = new TreeMap();
    private static TreeMap<String, Integer> location_id_map = new TreeMap();

    private static Integer get_country_id(String s2) {
        Integer id = country_id_map.get(s2);
        if (id == null) {
            country_id_map.put(s2, next_country_id);
            id = next_country_id;
            Integer n = next_country_id;
            Integer n2 = next_country_id = Integer.valueOf(next_country_id + 1);
        }
        return id;
    }

    private static Integer get_genre_id(String s2) {
        Integer id = genre_id_map.get(s2);
        if (id == null) {
            genre_id_map.put(s2, next_genre_id);
            id = next_genre_id;
            Integer n = next_genre_id;
            Integer n2 = next_genre_id = Integer.valueOf(next_genre_id + 1);
        }
        return id;
    }

    private static Integer get_keyword_id(String s2) {
        Integer id = keyword_id_map.get(s2);
        if (id == null) {
            keyword_id_map.put(s2, next_keyword_id);
            id = next_keyword_id;
            Integer n = next_keyword_id;
            Integer n2 = next_keyword_id = Integer.valueOf(next_keyword_id + 1);
        }
        return id;
    }

    private static Integer get_language_id(String s2) {
        Integer id = language_id_map.get(s2);
        if (id == null) {
            language_id_map.put(s2, next_language_id);
            id = next_language_id;
            Integer n = next_language_id;
            Integer n2 = next_language_id = Integer.valueOf(next_language_id + 1);
        }
        return id;
    }

    private static Integer get_location_id(String s2) {
        Integer id = location_id_map.get(s2);
        if (id == null) {
            location_id_map.put(s2, next_location_id);
            id = next_location_id;
            Integer n = next_location_id;
            Integer n2 = next_location_id = Integer.valueOf(next_location_id + 1);
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        String document_db_dir = args[0];
        String csv_dir = args[1];
        String neo4j_dir = args[2];
        new File(csv_dir).mkdirs();
        try (MovieDB database = MovieDB.open(document_db_dir);){
            FileWriter f_person = new FileWriter(csv_dir + "/person.csv");
            f_person.write("person_id:ID(Person)|name:string|gender:string|:LABEL\n");
            for (Person person : database.getByNamePrefix("")) {
                String name2 = person.getName();
                if (name2 == null) {
                    name2 = "";
                }
                f_person.write(person.getId() + "|" + name2.replace("\"", "\\\"") + "|" + person.getGender() + "|Person\n");
            }
            f_person.close();
            FileWriter f_movie = new FileWriter(csv_dir + "/movie.csv");
            f_movie.write("movie_id:ID(Movie)|title:string|year:int|color_info:string[]|running_times:string[]|:LABEL\n");
            FileWriter f_acts_in = new FileWriter(csv_dir + "/acts_in.csv");
            f_acts_in.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|role:string|position:int|note:string\n");
            FileWriter f_directs = new FileWriter(csv_dir + "/directs.csv");
            f_directs.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_camera = new FileWriter(csv_dir + "/camera.csv");
            f_camera.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_compose = new FileWriter(csv_dir + "/compose.csv");
            f_compose.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_edits = new FileWriter(csv_dir + "/edits.csv");
            f_edits.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_produces = new FileWriter(csv_dir + "/produces.csv");
            f_produces.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_prod_design = new FileWriter(csv_dir + "/production_design.csv");
            f_prod_design.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_design = new FileWriter(csv_dir + "/costume_design.csv");
            f_design.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string\n");
            FileWriter f_writes = new FileWriter(csv_dir + "/writes.csv");
            f_writes.write(":START_ID(Person)|:END_ID(Movie)|:TYPE|note:string|line_order:int|group_order:int|subgroup_order:int\n");
            FileWriter f_release_dates = new FileWriter(csv_dir + "/release_dates.csv");
            f_release_dates.write(":START_ID(Movie)|:END_ID(Country)|:TYPE|date:string|note:string\n");
            FileWriter f_certificates = new FileWriter(csv_dir + "/certificates.csv");
            f_certificates.write(":START_ID(Movie)|:END_ID(Country)|:TYPE|certificate:string|note:string\n");
            FileWriter f_has_genre = new FileWriter(csv_dir + "/has_genre.csv");
            f_has_genre.write(":START_ID(Movie)|:END_ID(Genre)|:TYPE\n");
            FileWriter f_has_keyword = new FileWriter(csv_dir + "/has_keyword.csv");
            f_has_keyword.write(":START_ID(Movie)|:END_ID(Keyword)|:TYPE\n");
            FileWriter f_has_language = new FileWriter(csv_dir + "/has_language.csv");
            f_has_language.write(":START_ID(Movie)|:END_ID(Language)|:TYPE|note:string\n");
            FileWriter f_has_location = new FileWriter(csv_dir + "/has_location.csv");
            f_has_location.write(":START_ID(Movie)|:END_ID(Location)|:TYPE|note:string\n");
            for (Movie movie : database.getByTitlePrefix("")) {
                Object country_id;
                String note;
                void var28_63;
                String string2;
                void var27_48;
                String note2;
                void var26_33;
                Object lid;
                int n = movie.getId();
                if (movie.getKeywords() != null) {
                    for (String string3 : movie.getKeywords()) {
                        void var28_67;
                        Integer n2 = ImportGraph.get_keyword_id(string3);
                        if (n2 == null) {
                            Integer n3 = 0;
                        }
                        f_has_keyword.write(n + "|" + var28_67 + "|HAS_KEYWORD\n");
                    }
                }
                if (movie.getLanguages() != null) {
                    for (Language language2 : movie.getLanguages()) {
                        void var30_87;
                        String string4;
                        String string5 = language2.getLanguage();
                        lid = ImportGraph.get_language_id(string5);
                        if (lid == null) {
                            lid = 0;
                        }
                        if ((string4 = language2.getNote()) == null) {
                            String string6 = "";
                        }
                        f_has_language.write(n + "|" + lid + "|HAS_LANGUAGE|" + var30_87.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getLocations() != null) {
                    for (Location location : movie.getLocations()) {
                        void var30_90;
                        String string7;
                        String string8 = location.getLocation();
                        lid = ImportGraph.get_location_id(string8);
                        if (lid == null) {
                            lid = 0;
                        }
                        if ((string7 = location.getNote()) == null) {
                            String string9 = "";
                        }
                        f_has_location.write(n + "|" + lid + "|HAS_LOCATION|" + var30_90.replace("\"", "\\\"") + "\n");
                    }
                }
                String string10 = "";
                String string11 = "";
                if (movie.getRunningTimes() != null) {
                    boolean bl = true;
                    for (RunningTime runningTime : movie.getRunningTimes()) {
                        boolean bl2;
                        String time = runningTime.getRunningTime();
                        String note22 = runningTime.getNote();
                        if (note22 != null) {
                            time = time + ":" + note22.replace("\"", "\\\"");
                        }
                        if (bl2) {
                            String string12 = time;
                            bl2 = false;
                            continue;
                        }
                        String string13 = (String)var26_33 + ";" + time;
                    }
                }
                if (movie.getColorInfo() != null) {
                    boolean bl = true;
                    for (ColorInfo colorInfo : movie.getColorInfo()) {
                        boolean bl3;
                        String color = colorInfo.getColorInfo();
                        note2 = colorInfo.getNote();
                        if (note2 != null) {
                            color = color + ":" + note2.replace("\"", "\\\"");
                        }
                        if (bl3) {
                            String string14 = color;
                            bl3 = false;
                            continue;
                        }
                        String string15 = (String)var27_48 + ";" + color;
                    }
                }
                if ((string2 = movie.getTitle()) == null) {
                    String string16 = "";
                }
                f_movie.write(n + "|" + var28_63.replace("\"", "\\\"") + "|" + movie.getYear() + "|" + (String)var27_48 + "|" + (String)var26_33 + "|Movie\n");
                if (movie.getGenres() != null) {
                    for (String string17 : movie.getGenres()) {
                        Integer genre_id = ImportGraph.get_genre_id(string17);
                        if (genre_id == null) {
                            genre_id = 0;
                        }
                        f_has_genre.write(n + "|" + genre_id + "|HAS_GENRE\n");
                    }
                }
                if (movie.getCertificates() != null) {
                    for (Certificate certificate : movie.getCertificates()) {
                        note = certificate.getNote();
                        if (note == null) {
                            note = "";
                        }
                        if ((country_id = ImportGraph.get_country_id(certificate.getCountry())) == null) {
                            country_id = 0;
                        }
                        f_certificates.write(n + "|" + country_id + "|" + "CERTIFIED_IN" + "|" + certificate.getCertificate() + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getReleaseDates() != null) {
                    for (Map.Entry entry : movie.getReleaseDates().entrySet()) {
                        Integer country_id2 = ImportGraph.get_country_id((String)entry.getKey());
                        if (country_id2 == null) {
                            country_id2 = 0;
                        }
                        country_id = ((List)entry.getValue()).iterator();
                        while (country_id.hasNext()) {
                            String date;
                            ReleaseDate d = (ReleaseDate)country_id.next();
                            String note4 = d.getNote();
                            if (note4 == null) {
                                note4 = "";
                            }
                            if ((date = d.getReleaseDate()) == null) {
                                date = "";
                            }
                            f_release_dates.write(n + "|" + country_id2 + "|" + "RELEASED_IN" + "|" + date + "|" + note4.replace("\"", "\\\"") + "\n");
                        }
                    }
                }
                if (movie.getDirectors() != null) {
                    for (CreditPerson creditPerson : movie.getDirectors()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_directs.write(creditPerson.getPersonId() + "|" + n + "|" + "DIRECTED" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getActors() != null) {
                    for (CreditActor creditActor : movie.getActors()) {
                        Integer pos = creditActor.getPosition();
                        note2 = creditActor.getNote();
                        String character = creditActor.getCharacter();
                        if (note2 == null) {
                            note2 = "";
                        }
                        if (character == null) {
                            character = "";
                        }
                        f_acts_in.write(creditActor.getPersonId() + "|" + n + "|" + "ACTS_IN" + "|" + character.replace("\"", "\\\"") + "|" + (pos == null ? 0 : pos) + "|" + note2.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getCinematographers() != null) {
                    for (CreditPerson creditPerson : movie.getCinematographers()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_camera.write(creditPerson.getPersonId() + "|" + n + "|" + "CINEMATOGRAPHER_FOR" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getComposers() != null) {
                    for (CreditPerson creditPerson : movie.getComposers()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_compose.write(creditPerson.getPersonId() + "|" + n + "|" + "COMPOSER_FOR" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getEditors() != null) {
                    for (CreditPerson creditPerson : movie.getEditors()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_edits.write(creditPerson.getPersonId() + "|" + n + "|" + "EDITED" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getCostumeDesigners() != null) {
                    for (CreditPerson creditPerson : movie.getCostumeDesigners()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_design.write(creditPerson.getPersonId() + "|" + n + "|" + "COSTUME_DESIGNER_FOR" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getProductionDesigners() != null) {
                    for (CreditPerson creditPerson : movie.getProductionDesigners()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_prod_design.write(creditPerson.getPersonId() + "|" + n + "|" + "PRODUCTION_DESIGNER_FOR" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getProducers() != null) {
                    for (CreditPerson creditPerson : movie.getProducers()) {
                        note = creditPerson.getNote();
                        if (note == null) {
                            note = "";
                        }
                        f_produces.write(creditPerson.getPersonId() + "|" + n + "|" + "PRODUCED" + "|" + note.replace("\"", "\\\"") + "\n");
                    }
                }
                if (movie.getWriters() == null) continue;
                for (CreditWriter creditWriter : movie.getWriters()) {
                    note = creditWriter.getNote();
                    if (note == null) {
                        note = "";
                    }
                    f_writes.write(creditWriter.getPersonId() + "|" + n + "|" + "WROTE" + "|" + note.replace("\"", "\\\"") + "|" + creditWriter.getLineOrder() + "|" + creditWriter.getGroupOrder() + "|" + creditWriter.getSubgroupOrder() + "\n");
                }
            }
            f_movie.close();
            f_acts_in.close();
            f_compose.close();
            f_directs.close();
            f_edits.close();
            f_design.close();
            f_writes.close();
            f_produces.close();
            f_camera.close();
            f_prod_design.close();
            f_certificates.close();
            f_release_dates.close();
            f_has_genre.close();
            f_has_keyword.close();
            f_has_language.close();
            f_has_location.close();
            FileWriter f_country = new FileWriter(csv_dir + "/country.csv");
            f_country.write("country_id:ID(Country)|country:string|:LABEL\n");
            for (Map.Entry<String, Integer> entry : country_id_map.entrySet()) {
                f_country.write(entry.getValue() + "|" + entry.getKey() + "|Country\n");
            }
            f_country.close();
            FileWriter fileWriter = new FileWriter(csv_dir + "/genres.csv");
            fileWriter.write("genre_id:ID(Genre)|genre:string|:LABEL\n");
            for (Map.Entry<String, Integer> entry : genre_id_map.entrySet()) {
                fileWriter.write(entry.getValue() + "|" + entry.getKey() + "|Genre\n");
            }
            fileWriter.close();
            FileWriter fileWriter2 = new FileWriter(csv_dir + "/keywords.csv");
            fileWriter2.write("keyword_id:ID(Keyword)|keyword:string|:LABEL\n");
            for (Map.Entry<String, Integer> entry : keyword_id_map.entrySet()) {
                String string18 = entry.getKey();
                fileWriter2.write(entry.getValue() + "|" + string18.replace("\"", "\\\"") + "|Keyword\n");
            }
            fileWriter2.close();
            FileWriter fileWriter3 = new FileWriter(csv_dir + "/languages.csv");
            fileWriter3.write("language_id:ID(Language)|language:string|:LABEL\n");
            for (Map.Entry<String, Integer> entry : language_id_map.entrySet()) {
                fileWriter3.write(entry.getValue() + "|" + entry.getKey() + "|Language\n");
            }
            fileWriter3.close();
            FileWriter fileWriter4 = new FileWriter(csv_dir + "/locations.csv");
            fileWriter4.write("location_id:ID(Location)|location:string|:LABEL\n");
            for (Map.Entry<String, Integer> map_entry : location_id_map.entrySet()) {
                String string19 = map_entry.getKey();
                fileWriter4.write(map_entry.getValue() + "|" + string19.replace("\"", "\\\"") + "|Location\n");
            }
            fileWriter4.close();
        }
        ImportTool.main(new String[]{"--delimiter", "|", "--into", neo4j_dir, "--nodes", csv_dir + "/movie.csv", "--nodes", csv_dir + "/person.csv", "--nodes", csv_dir + "/country.csv", "--nodes", csv_dir + "/genres.csv", "--nodes", csv_dir + "/keywords.csv", "--nodes", csv_dir + "/languages.csv", "--nodes", csv_dir + "/locations.csv", "--relationships", csv_dir + "/acts_in.csv", "--relationships", csv_dir + "/directs.csv", "--relationships", csv_dir + "/camera.csv", "--relationships", csv_dir + "/compose.csv", "--relationships", csv_dir + "/edits.csv", "--relationships", csv_dir + "/produces.csv", "--relationships", csv_dir + "/production_design.csv", "--relationships", csv_dir + "/costume_design.csv", "--relationships", csv_dir + "/certificates.csv", "--relationships", csv_dir + "/release_dates.csv", "--relationships", csv_dir + "/has_genre.csv", "--relationships", csv_dir + "/has_keyword.csv", "--relationships", csv_dir + "/has_language.csv", "--relationships", csv_dir + "/has_location.csv", "--relationships", csv_dir + "/writes.csv"});
    }
}

