/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.databases.moviedb.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import uk.ac.cam.cl.databases.moviedb.MovieDB;

public class ImportDocument {
    private final File moviesFile;
    private final File peopleFile;
    private final File outputDir;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public ImportDocument(File inputFile, File peopleFile, File outputDir) {
        this.moviesFile = inputFile;
        this.peopleFile = peopleFile;
        this.outputDir = outputDir;
    }

    private BufferedReader readFile(File inputFile) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(inputFile)), UTF8));
    }

    public void process() throws IOException {
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        try (MovieDB movieDB = MovieDB.open(this.outputDir.getAbsolutePath());){
            try (BufferedReader input2 = this.readFile(this.moviesFile);){
                input2.lines().forEach(json -> movieDB.putMovie((String)json));
            }
            input2 = this.readFile(this.peopleFile);
            var4_6 = null;
            try {
                input2.lines().forEach(json -> movieDB.putPerson((String)json));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (input2 != null) {
                    if (var4_6 != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        input2.close();
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: Import movies_doc.json.gz people_doc.json.gz output-dir");
            System.exit(1);
        }
        new ImportDocument(new File(args[0]), new File(args[1]), new File(args[2])).process();
    }
}

