/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade.lucene;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.neo4j.upgrade.loader.EmbeddedJarLoader;

class IndexUpgraderWrapper
implements AutoCloseable {
    private static final String LUCENE_INDEX_UPGRADER_CLASS_NAME = "org.apache.lucene.index.IndexUpgrader";
    private EmbeddedJarLoader luceneLoader;
    private MethodHandle mainMethod;
    private Supplier<EmbeddedJarLoader> jarLoaderSupplier;

    public IndexUpgraderWrapper(Supplier<EmbeddedJarLoader> jarLoaderSupplier) {
        this.jarLoaderSupplier = jarLoaderSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeIndex(Path indexPath) throws Throwable {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.mainMethod == null) {
                this.luceneLoader = this.jarLoaderSupplier.get();
                Class upgrader = this.luceneLoader.loadEmbeddedClass(LUCENE_INDEX_UPGRADER_CLASS_NAME);
                MethodHandles.Lookup lookup2 = MethodHandles.lookup();
                this.mainMethod = lookup2.findStatic(upgrader, "main", MethodType.methodType(Void.TYPE, String[].class));
            }
            Thread.currentThread().setContextClassLoader(this.luceneLoader.getJarsClassLoader());
            this.mainMethod.invokeExact(new String[]{indexPath.toString()});
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.luceneLoader != null) {
            this.luceneLoader.close();
        }
    }
}

