/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public final class MemoryManager {
    private static final long GRAB_SIZE = FeatureToggles.getInteger(MemoryManager.class, "GRAB_SIZE", 524288);
    private long memoryReserve;
    private final long alignment;
    private Slab slabs;

    public MemoryManager(long expectedMaxMemory, long alignment) {
        this.memoryReserve = expectedMaxMemory;
        this.alignment = alignment;
    }

    public synchronized long allocateAligned(long bytes2) {
        if (this.slabs == null || !this.slabs.canAllocate(bytes2)) {
            long slabGrab = Math.min(GRAB_SIZE, this.memoryReserve);
            if (slabGrab < bytes2) {
                slabGrab = bytes2;
                Slab slab = new Slab(this.slabs, slabGrab, this.alignment);
                if (slab.canAllocate(bytes2)) {
                    this.memoryReserve -= slabGrab;
                    this.slabs = slab;
                    return this.slabs.allocate(bytes2);
                }
                slab.free();
                slabGrab = bytes2 + this.alignment;
            }
            this.memoryReserve -= slabGrab;
            this.slabs = new Slab(this.slabs, slabGrab, this.alignment);
        }
        return this.slabs.allocate(bytes2);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        Slab current = this.slabs;
        while (current != null) {
            current.free();
            current = current.next;
        }
    }

    private static class Slab {
        public final Slab next;
        private final long address;
        private final long limit;
        private final long alignMask;
        private long nextAlignedPointer;

        public Slab(Slab next2, long size2, long alignment) {
            this.next = next2;
            this.address = UnsafeUtil.allocateMemory(size2);
            this.limit = this.address + size2;
            this.alignMask = alignment - 1L;
            this.nextAlignedPointer = this.nextAligned(this.address);
        }

        private long nextAligned(long pointer) {
            if ((pointer & (this.alignMask ^ 0xFFFFFFFFFFFFFFFFL)) == pointer) {
                return pointer;
            }
            return pointer + this.alignMask & (this.alignMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public long allocate(long bytes2) {
            long allocation = this.nextAlignedPointer;
            this.nextAlignedPointer = this.nextAligned(this.nextAlignedPointer + bytes2);
            return allocation;
        }

        public void free() {
            UnsafeUtil.free(this.address);
        }

        public boolean canAllocate(long bytes2) {
            return this.nextAlignedPointer + bytes2 <= this.limit;
        }
    }
}

