/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import java.util.Objects;

public class FeatureToggles {
    public static boolean flag(Class<?> location, String name2, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location, name2), defaultValue);
    }

    public static boolean packageFlag(Class<?> location, String name2, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location.getPackage(), name2), defaultValue);
    }

    public static long getLong(Class<?> location, String name2, long defaultValue) {
        return Long.getLong(FeatureToggles.name(location, name2), defaultValue);
    }

    public static int getInteger(Class<?> location, String name2, int defaultValue) {
        return Integer.getInteger(FeatureToggles.name(location, name2), defaultValue);
    }

    public static double getDouble(Class<?> location, String name2, double defaultValue) {
        try {
            String propertyValue = System.getProperty(FeatureToggles.name(location, name2));
            if (propertyValue != null && propertyValue.length() > 0) {
                return Double.parseDouble(propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String getString(Class<?> location, String name2, String defaultValue) {
        String propertyValue = System.getProperty(FeatureToggles.name(location, name2));
        return propertyValue == null || propertyValue.isEmpty() ? defaultValue : propertyValue;
    }

    public static <E extends Enum<E>> E flag(Class<?> location, String name2, E defaultValue) {
        return FeatureToggles.enumProperty(defaultValue.getDeclaringClass(), FeatureToggles.name(location, name2), defaultValue);
    }

    public static void set(Class<?> location, String name2, Object value) {
        System.setProperty(FeatureToggles.name(location, name2), Objects.toString(value));
    }

    public static void clear(Class<?> location, String name2) {
        System.clearProperty(FeatureToggles.name(location, name2));
    }

    public static String toggle(Class<?> location, String name2, Object value) {
        return FeatureToggles.toggle(FeatureToggles.name(location, name2), Objects.toString(value));
    }

    private static String toggle(String key, String value) {
        return "-D" + key + "=" + value;
    }

    private FeatureToggles() {
    }

    private static String name(Class<?> location, String name2) {
        return location.getCanonicalName() + "." + name2;
    }

    private static String name(Package location, String name2) {
        return location.getName() + "." + name2;
    }

    private static boolean booleanProperty(String flag, boolean defaultValue) {
        return FeatureToggles.parseBoolean(System.getProperty(flag), defaultValue);
    }

    private static boolean parseBoolean(String value, boolean defaultValue) {
        return defaultValue ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
    }

    private static <E extends Enum<E>> E enumProperty(Class<E> enumClass, String name2, E defaultValue) {
        try {
            return Enum.valueOf(enumClass, System.getProperty(name2, defaultValue.name()));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

