/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public abstract class CoarseBoundedProgressExecutionMonitor
extends ExecutionMonitor.Adapter {
    private final long totalNumberOfBatches;
    private long[] prevDoneBatches;
    private long totalReportedBatches = 0L;

    public CoarseBoundedProgressExecutionMonitor(long highNodeId, long highRelationshipId, Configuration configuration) {
        super(1L, TimeUnit.SECONDS);
        this.totalNumberOfBatches = highNodeId / (long)configuration.batchSize() * 3L + highRelationshipId / (long)configuration.batchSize() * 4L;
    }

    protected long total() {
        return this.totalNumberOfBatches;
    }

    @Override
    public void check(StageExecution[] executions) {
        this.update(executions);
    }

    @Override
    public void start(StageExecution[] executions) {
        this.prevDoneBatches = new long[executions.length];
    }

    private void update(StageExecution[] executions) {
        long diff2 = 0L;
        for (int i = 0; i < executions.length; ++i) {
            long doneBatches = this.doneBatches(executions[i]);
            diff2 += doneBatches - this.prevDoneBatches[i];
            this.prevDoneBatches[i] = doneBatches;
        }
        if (diff2 > 0L) {
            this.totalReportedBatches += diff2;
            this.progress(diff2);
        }
    }

    protected abstract void progress(long var1);

    private long doneBatches(StageExecution execution) {
        Step<?> step = Iterables.last(execution.steps());
        return step.stats().stat(Keys.done_batches).asLong();
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        this.progress(this.totalNumberOfBatches - this.totalReportedBatches);
    }
}

