/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class Header {
    private final Entry[] entries;

    public Header(Entry ... entries) {
        this.entries = entries;
    }

    public Entry[] entries() {
        return this.entries;
    }

    public Entry entry(Type type) {
        Entry result2 = null;
        for (Entry entry : this.entries) {
            if (entry.type() != type) continue;
            if (result2 != null) {
                throw new IllegalStateException("Multiple header entries of type " + (Object)((Object)type));
            }
            result2 = entry;
        }
        return result2;
    }

    public String toString() {
        return Arrays.toString(this.entries);
    }

    public static class Entry {
        private final String name;
        private final Type type;
        private final String groupName;
        private final Extractor<?> extractor;

        public Entry(String name2, Type type, String groupName, Extractor<?> extractor) {
            this.name = name2;
            this.type = type;
            this.groupName = groupName;
            this.extractor = extractor;
        }

        public String toString() {
            return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.toString().toLowerCase() : this.type.name()) + (this.groupName != null ? "(" + this.groupName + ")" : "");
        }

        public Extractor<?> extractor() {
            return this.extractor;
        }

        public Type type() {
            return this.type;
        }

        public String groupName() {
            return this.groupName;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            if (this.name != null) {
                result2 = 31 * result2 + this.name.hashCode();
            }
            result2 = 31 * result2 + this.type.hashCode();
            if (this.groupName != null) {
                result2 = 31 * result2 + this.groupName.hashCode();
            }
            result2 = 31 * result2 + this.extractor.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other2 = (Entry)obj;
            return this.nullSafeEquals(this.name, other2.name) && this.type == other2.type && this.nullSafeEquals(this.groupName, other2.groupName) && this.extractorEquals(this.extractor, other2.extractor);
        }

        private boolean nullSafeEquals(Object o1, Object o2) {
            return o1 == null || o2 == null ? o1 == o2 : o1.equals(o2);
        }

        private boolean extractorEquals(Extractor<?> first, Extractor<?> other2) {
            if (first == null || other2 == null) {
                return first == other2;
            }
            return first.getClass().equals(other2.getClass());
        }
    }

    public static interface Factory {
        public Header create(CharSeeker var1, Configuration var2, IdType var3);
    }
}

