/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.function.Function;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserialization;

public class ExternalPropertiesDecorator
implements Function<InputNode, InputNode> {
    private final InputEntityDeserializer<InputNode> deserializer;
    private InputNode currentExternal;
    private final UpdateBehaviour updateBehaviour;

    public ExternalPropertiesDecorator(DataFactory<InputNode> data, Header.Factory headerFactory, Configuration config, IdType idType, UpdateBehaviour updateBehaviour, Collector badCollector) {
        this.updateBehaviour = updateBehaviour;
        CharSeeker dataStream = data.create(config).stream();
        Header header = headerFactory.create(dataStream, config, idType);
        this.deserializer = new InputEntityDeserializer<InputNode>(header, dataStream, config.delimiter(), new InputNodeDeserialization(dataStream, header, new Groups(), idType.idsAreExternal()), value -> value, Validators.emptyValidator(), badCollector);
    }

    @Override
    public InputNode apply(InputNode from2) throws RuntimeException {
        Object id = from2.id();
        if (this.currentExternal != null) {
            if (id.equals(this.currentExternal.id())) {
                this.decorate(from2);
                this.currentExternal = null;
            } else {
                return from2;
            }
        }
        while (this.deserializer.hasNext()) {
            this.currentExternal = (InputNode)this.deserializer.next();
            if (!id.equals(this.currentExternal.id())) break;
            this.decorate(from2);
        }
        return from2;
    }

    private void decorate(InputNode from2) {
        from2.updateProperties(this.updateBehaviour, this.currentExternal.properties());
    }
}

