/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.lang.reflect.Array;
import java.util.Arrays;

public enum UpdateBehaviour {
    OVERWRITE{

        @Override
        public Object merge(Object existing, Object additional) {
            return additional;
        }
    }
    ,
    ADD{

        @Override
        public Object merge(Object existing, Object additional) {
            Object[] result2;
            if (existing.getClass().isArray()) {
                result2 = Arrays.copyOf((Object[])existing, Array.getLength(existing) + 1);
                result2[result2.length - 1] = additional;
            } else if (additional.getClass().isArray()) {
                int length2 = Array.getLength(additional);
                result2 = (Object[])Array.newInstance(existing.getClass(), 1 + length2);
                result2[0] = existing;
                for (int i = 0; i < length2; ++i) {
                    result2[1 + i] = Array.get(additional, i);
                }
            } else {
                result2 = (Object[])Array.newInstance(existing.getClass(), 2);
                result2[0] = existing;
                result2[1] = additional;
            }
            return result2;
        }
    };


    public abstract Object merge(Object var1, Object var2);
}

