/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;

public class InputNodeCacher
extends InputEntityCacher<InputNode> {
    private String[] previousLabels = InputEntity.NO_LABELS;

    public InputNodeCacher(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int bufferSize, int batchSize) throws IOException {
        super(channel, header, recordFormats, bufferSize, batchSize, 1);
    }

    @Override
    protected void writeEntity(InputNode node) throws IOException {
        super.writeEntity(node);
        this.writeGroup(node.group(), 0);
        this.writeValue(node.id());
        if (node.hasLabelField()) {
            this.channel.put((byte)3);
            this.channel.putLong(node.labelField());
        } else {
            String[] labels2 = node.labels();
            this.writeLabelDiff((byte)1, this.previousLabels, labels2);
            this.writeLabelDiff((byte)2, labels2, this.previousLabels);
            this.channel.put((byte)0);
            this.previousLabels = labels2;
        }
    }

    @Override
    protected void clearState() {
        this.previousLabels = InputEntity.NO_LABELS;
        super.clearState();
    }

    protected void writeLabelDiff(byte mode, String[] compare, String[] with) throws IOException {
        for (String value : compare) {
            if (ArrayUtil.contains(with, value)) continue;
            this.channel.put(mode);
            this.writeToken((byte)1, value);
        }
    }
}

