/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputNode
extends InputEntity {
    private final Group group;
    private final Object id;
    private String[] labels;
    private Long labelField;

    public InputNode(String sourceDescription, long lineNumber, long position2, Object id, Object[] properties, Long firstPropertyId, String[] labels2, Long labelField) {
        this(sourceDescription, lineNumber, position2, Group.GLOBAL, id, properties, firstPropertyId, labels2, labelField);
    }

    public InputNode(String sourceDescription, long lineNumber, long position2, Group group2, Object id, Object[] properties, Long firstPropertyId, String[] labels2, Long labelField) {
        super(sourceDescription, lineNumber, position2, properties, firstPropertyId);
        this.group = group2;
        this.id = id;
        this.labels = labels2;
        this.labelField = labelField;
    }

    public Group group() {
        return this.group;
    }

    public Object id() {
        return this.id;
    }

    public String[] labels() {
        return this.labels;
    }

    public boolean hasLabelField() {
        return this.labelField != null;
    }

    public Long labelField() {
        return this.labelField;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        fields.add(Pair.of("id", this.id));
        fields.add(Pair.of("group", this.group));
        if (this.hasLabelField()) {
            fields.add(Pair.of("labelField", this.labelField));
        } else if (this.labels != null && this.labels.length > 0) {
            fields.add(Pair.of("labels", Arrays.toString(this.labels)));
        }
    }

    public void setLabels(String[] labels2) {
        this.labels = labels2;
        this.labelField = null;
    }
}

