/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.util.collection.ContinuableArrayCursor;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;
import org.neo4j.unsafe.impl.batchimport.staging.TicketedProcessing;

abstract class InputEntityReader<ENTITY extends InputEntity>
extends InputIterator.Adapter<ENTITY> {
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private int lineNumber;
    private TicketedProcessing<byte[], Void, Object[]> processing;
    private final PrimitiveIntObjectMap<String>[] tokens = new PrimitiveIntObjectMap[4];
    private final Runnable closeAction;
    private final ReadAheadLogChannel cacheChannel;
    private final ContinuableArrayCursor<Object> processedEntities;

    InputEntityReader(StoreChannel channel, StoreChannel header, int bufferSize, Runnable closeAction, int maxNbrOfProcessors) throws IOException {
        this.tokens[0] = Primitive.intObjectMap();
        this.tokens[1] = Primitive.intObjectMap();
        this.tokens[2] = Primitive.intObjectMap();
        this.tokens[3] = Primitive.intObjectMap();
        this.cacheChannel = this.reader(channel, bufferSize);
        this.closeAction = closeAction;
        this.readHeader(header);
        BiFunction<byte[], Void, Object[]> processor = (batchData, ignore) -> {
            ProcessorState state = new ProcessorState((byte[])batchData);
            try {
                int nbrOfEntries = state.batchChannel.getInt();
                Object[] result2 = new Object[nbrOfEntries];
                for (int i = 0; i < nbrOfEntries; ++i) {
                    result2[i] = this.readOneEntity(state);
                }
                return result2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        };
        Supplier<Void> noState = () -> null;
        this.processing = new TicketedProcessing<byte[], Void, Object[]>(this.getClass().getName(), maxNbrOfProcessors, processor, noState);
        BatchProvidingIterator iterator2 = new BatchProvidingIterator();
        this.processing.slurp(iterator2, true);
        this.processedEntities = new ContinuableArrayCursor(() -> this.processing.next());
    }

    private ReadAheadLogChannel reader(StoreChannel channel, int bufferSize) throws IOException {
        return new ReadAheadLogChannel(new PhysicalLogVersionedStoreChannel(channel, 0L, 0), LogVersionBridge.NO_MORE_CHANNELS, bufferSize);
    }

    private void readHeader(StoreChannel header) throws IOException {
        try (ReadAheadLogChannel reader = this.reader(header, (int)ByteUnit.kibiBytes(8L));){
            byte type;
            int[] tokenIds = new int[4];
            while ((type = reader.get()) != -2) {
                int tokenId;
                byte by2 = type;
                tokenIds[by2] = tokenIds[by2] + 1;
                String name2 = (String)ValueType.stringType().read(reader);
                this.tokens[type].put(tokenId, name2);
            }
        }
    }

    protected final ENTITY readOneEntity(ProcessorState state) {
        ReadableClosablePositionAwareChannel channel = state.batchChannel;
        try {
            Object properties = this.readProperties(channel);
            if (properties == null) {
                return null;
            }
            return this.readNextOrNull(properties, state);
        }
        catch (IOException e) {
            throw new InputException("Couldn't read cached node data", e);
        }
    }

    @Override
    protected ENTITY fetchNextOrNull() {
        return (ENTITY)(this.processedEntities.next() ? (InputEntity)this.processedEntities.get() : null);
    }

    protected abstract ENTITY readNextOrNull(Object var1, ProcessorState var2) throws IOException;

    private Object readProperties(ReadableClosablePositionAwareChannel channel) throws IOException {
        short count2 = channel.getShort();
        switch (count2) {
            case -3: {
                return null;
            }
            case -1: {
                return channel.getLong();
            }
            case 0: {
                return InputEntity.NO_PROPERTIES;
            }
        }
        Object[] properties = new Object[count2 * 2];
        for (int i = 0; i < properties.length; ++i) {
            properties[i++] = this.readToken((byte)0, channel);
            properties[i] = this.readValue(channel);
        }
        return properties;
    }

    protected Object readToken(byte type, ReadableClosablePositionAwareChannel channel) throws IOException {
        int id = channel.getInt();
        if (id == -1) {
            return channel.getInt();
        }
        String name2 = this.tokens[type].get(id);
        if (name2 == null) {
            throw new IllegalArgumentException("Unknown token " + id);
        }
        return name2;
    }

    protected Object readValue(ReadableClosablePositionAwareChannel channel) throws IOException {
        return ValueType.typeOf(channel.get()).read(channel);
    }

    protected Group readGroup(int slot, ProcessorState state) throws IOException {
        ReadableClosablePositionAwareChannel channel = state.batchChannel;
        byte groupMode = channel.get();
        switch (groupMode) {
            case 0: {
                return state.previousGroups[slot];
            }
            case 1: {
                state.previousGroups[slot] = new Group.Adapter(channel.getInt(), (String)this.readToken((byte)3, channel));
                return state.previousGroups[slot];
            }
        }
        throw new IllegalArgumentException("Unknown group mode " + groupMode);
    }

    @Override
    public String sourceDescription() {
        return "cache";
    }

    @Override
    public long lineNumber() {
        return this.lineNumber;
    }

    @Override
    public long position() {
        try {
            return this.cacheChannel.getCurrentPosition(this.positionMarker).getByteOffset();
        }
        catch (IOException e) {
            throw new InputException("Couldn't get position from cached input data", e);
        }
    }

    @Override
    public void close() {
        try {
            this.cacheChannel.close();
            this.closeAction.run();
        }
        catch (IOException e) {
            throw new InputException("Couldn't close channel for cached input data", e);
        }
    }

    @Override
    public int processors(int delta) {
        return this.processing.processors(delta);
    }

    private class BatchProvidingIterator
    extends PrefetchingIterator<byte[]> {
        private BatchProvidingIterator() {
        }

        @Override
        protected byte[] fetchNextOrNull() {
            try {
                int batchSize = Utils.safeCastLongToInt(InputEntityReader.this.cacheChannel.getLong());
                if ((long)batchSize == 0L) {
                    return null;
                }
                byte[] bytes2 = new byte[batchSize];
                InputEntityReader.this.cacheChannel.get(bytes2, batchSize);
                return bytes2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class ProcessorState {
        protected final Group[] previousGroups;
        protected String previousType;
        protected String[] previousLabels = InputEntity.NO_LABELS;
        protected ReadableClosablePositionAwareChannel batchChannel;

        public ProcessorState(byte[] batchData) {
            this.batchChannel = new InMemoryClosableChannel(batchData, true);
            this.previousGroups = new Group[2];
            for (int i = 0; i < this.previousGroups.length; ++i) {
                this.previousGroups[i] = Group.GLOBAL;
            }
        }
    }
}

