/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;

public abstract class InputEntity
implements SourceTraceability {
    public static final Object[] NO_PROPERTIES = new Object[0];
    public static final String[] NO_LABELS = new String[0];
    private Object[] properties;
    private Long firstPropertyId;
    private final String sourceDescription;
    private final long lineNumber;
    private final long position;

    public InputEntity(String sourceDescription, long sourceLineNumber, long sourcePosition, Object[] properties, Long firstPropertyId) {
        assert (properties.length % 2 == 0) : Arrays.toString(properties);
        this.sourceDescription = sourceDescription;
        this.lineNumber = sourceLineNumber;
        this.position = sourcePosition;
        this.properties = properties;
        this.firstPropertyId = firstPropertyId;
    }

    public Object[] properties() {
        return this.properties;
    }

    public void updateProperties(UpdateBehaviour behaviour, Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0) : Arrays.toString(keyValuePairs);
        if (this.properties == null || this.properties.length == 0) {
            this.setProperties(keyValuePairs);
            return;
        }
        int newLength = this.collectiveNumberOfKeys(this.properties, keyValuePairs) * 2;
        this.properties = newLength == this.properties.length ? this.properties : Arrays.copyOf(this.properties, newLength);
        for (int i = 0; i < keyValuePairs.length; ++i) {
            Object key = keyValuePairs[i++];
            Object value = keyValuePairs[i];
            this.updateProperty(key, value, behaviour);
        }
    }

    private int collectiveNumberOfKeys(Object[] properties, Object[] otherProperties) {
        int collidingKeys = 0;
        block0: for (int i = 0; i < properties.length; i += 2) {
            Object key = properties[i];
            for (int j = 0; j < otherProperties.length; j += 2) {
                Object otherKey = otherProperties[j];
                if (!otherKey.equals(key)) continue;
                ++collidingKeys;
                continue block0;
            }
        }
        return properties.length / 2 + otherProperties.length / 2 - collidingKeys;
    }

    private void updateProperty(Object key, Object value, UpdateBehaviour behaviour) {
        int free = 0;
        for (int i = 0; i < this.properties.length; ++i) {
            Object existingKey;
            if ((existingKey = this.properties[i++]) == null) {
                free = i - 1;
                break;
            }
            if (!existingKey.equals(key)) continue;
            this.properties[i] = behaviour.merge(this.properties[i], value);
            return;
        }
        this.properties[free++] = key;
        this.properties[free] = value;
    }

    public void setProperties(Object ... keyValuePairs) {
        this.properties = keyValuePairs;
        this.firstPropertyId = null;
    }

    public boolean hasFirstPropertyId() {
        return this.firstPropertyId != null;
    }

    public long firstPropertyId() {
        return this.firstPropertyId;
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public long lineNumber() {
        return this.lineNumber;
    }

    @Override
    public long position() {
        return this.position;
    }

    public String toString() {
        ArrayList fields = new ArrayList();
        this.toStringFields(fields);
        StringBuilder builder = new StringBuilder("%s:");
        Object[] arguments2 = new Object[fields.size() + 1];
        int cursor = 0;
        arguments2[cursor++] = this.getClass().getSimpleName();
        for (Pair pair : fields) {
            builder.append("%n   %s");
            arguments2[cursor++] = (String)pair.first() + ": " + pair.other();
        }
        return String.format(builder.append("%n").toString(), arguments2);
    }

    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        fields.add(Pair.of("source", this.sourceDescription + ":" + this.lineNumber));
        if (this.hasFirstPropertyId()) {
            fields.add(Pair.of("nextProp", this.firstPropertyId));
        } else if (this.properties != null && this.properties.length > 0) {
            fields.add(Pair.of("properties", Arrays.toString(this.properties)));
        }
    }
}

