/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.collection.primitive.PrimitiveLongStack;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.RadixCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Tracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Workers;

public class ParallelSort {
    private final int[] radixIndexCount;
    private final RadixCalculator radixCalculator;
    private final LongArray dataCache;
    private final long highestSetIndex;
    private final Tracker tracker;
    private final int threads;
    private long[][] sortBuckets;
    private final ProgressListener progress;
    private final Comparator comparator;
    public static final Comparator DEFAULT = new Comparator(){

        @Override
        public boolean lt(long left2, long pivot) {
            return Utils.unsignedCompare(left2, pivot, Utils.CompareType.LT);
        }

        @Override
        public boolean ge(long right2, long pivot) {
            return Utils.unsignedCompare(right2, pivot, Utils.CompareType.GE);
        }

        @Override
        public long dataValue(long dataValue) {
            return dataValue;
        }
    };

    public ParallelSort(Radix radix, LongArray dataCache, long highestSetIndex, Tracker tracker, int threads, ProgressListener progress, Comparator comparator) {
        this.progress = progress;
        this.comparator = comparator;
        this.radixIndexCount = radix.getRadixIndexCounts();
        this.radixCalculator = radix.calculator();
        this.dataCache = dataCache;
        this.highestSetIndex = highestSetIndex;
        this.tracker = tracker;
        this.threads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long[][] run() throws InterruptedException {
        long[][] sortParams = this.sortRadix();
        int threadsNeeded = 0;
        for (int i = 0; i < this.threads && sortParams[i][1] != 0L; ++i) {
            ++threadsNeeded;
        }
        Workers<SortWorker> sortWorkers = new Workers<SortWorker>("SortWorker");
        this.progress.started("SORT");
        for (int i = 0; i < threadsNeeded && sortParams[i][1] != 0L; ++i) {
            sortWorkers.start(new SortWorker(sortParams[i][0], sortParams[i][1]));
        }
        try {
            sortWorkers.awaitAndThrowOnError(RuntimeException.class);
        }
        finally {
            this.progress.done();
        }
        return this.sortBuckets;
    }

    private long[][] sortRadix() throws InterruptedException {
        long[][] rangeParams = new long[this.threads][2];
        int[] bucketRange = new int[this.threads];
        Workers<TrackerInitializer> initializers = new Workers<TrackerInitializer>("TrackerInitializer");
        this.sortBuckets = new long[this.threads][2];
        long dataSize = this.highestSetIndex + 1L;
        long bucketSize = dataSize / (long)this.threads;
        long count2 = 0L;
        long fullCount = 0L;
        this.progress.started("SPLIT");
        int threadIndex = 0;
        for (int i = 0; i < this.radixIndexCount.length && threadIndex < this.threads; ++i) {
            if (count2 + (long)this.radixIndexCount[i] > bucketSize) {
                bucketRange[threadIndex] = count2 == 0L ? i : i - 1;
                rangeParams[threadIndex][0] = fullCount;
                if (count2 != 0L) {
                    rangeParams[threadIndex][1] = count2;
                    fullCount += count2;
                    this.progress.add(count2);
                    count2 = this.radixIndexCount[i];
                } else {
                    rangeParams[threadIndex][1] = this.radixIndexCount[i];
                    fullCount += (long)this.radixIndexCount[i];
                    this.progress.add(this.radixIndexCount[i]);
                }
                initializers.start(new TrackerInitializer(threadIndex, rangeParams[threadIndex], threadIndex > 0 ? bucketRange[threadIndex - 1] : -1, bucketRange[threadIndex], this.sortBuckets[threadIndex]));
                ++threadIndex;
            } else {
                count2 += (long)this.radixIndexCount[i];
            }
            if (threadIndex != this.threads - 1 && i != this.radixIndexCount.length - 1) continue;
            bucketRange[threadIndex] = this.radixIndexCount.length;
            rangeParams[threadIndex][0] = fullCount;
            rangeParams[threadIndex][1] = dataSize - fullCount;
            initializers.start(new TrackerInitializer(threadIndex, rangeParams[threadIndex], threadIndex > 0 ? bucketRange[threadIndex - 1] : -1, bucketRange[threadIndex], this.sortBuckets[threadIndex]));
            break;
        }
        this.progress.done();
        Throwable error = initializers.await();
        long[] bucketIndex = new long[this.threads];
        int i = 0;
        for (TrackerInitializer initializer : initializers) {
            bucketIndex[i++] = initializer.bucketIndex;
        }
        if (error != null) {
            throw new AssertionError(error.getMessage() + "\n" + this.dumpBuckets(rangeParams, bucketRange, bucketIndex), error);
        }
        return rangeParams;
    }

    private String dumpBuckets(long[][] rangeParams, int[] bucketRange, long[] bucketIndex) {
        StringBuilder builder = new StringBuilder();
        builder.append("rangeParams:\n");
        for (long[] range2 : rangeParams) {
            builder.append("  ").append(Arrays.toString(range2)).append("\n");
        }
        builder.append("bucketRange:\n");
        for (int range3 : bucketRange) {
            builder.append("  ").append(range3).append("\n");
        }
        builder.append("bucketIndex:\n");
        for (long index : bucketIndex) {
            builder.append("  ").append(index).append("\n");
        }
        return builder.toString();
    }

    private class TrackerInitializer
    implements Runnable {
        private final long[] rangeParams;
        private final int lowRadixRange;
        private final int highRadixRange;
        private final int threadIndex;
        private long bucketIndex;
        private final long[] result;

        TrackerInitializer(int threadIndex, long[] rangeParams, int lowRadixRange, int highRadixRange, long[] result2) {
            this.threadIndex = threadIndex;
            this.rangeParams = rangeParams;
            this.lowRadixRange = lowRadixRange;
            this.highRadixRange = highRadixRange;
            this.result = result2;
        }

        @Override
        public void run() {
            for (long i = 0L; i <= ParallelSort.this.highestSetIndex; ++i) {
                int rIndex = ParallelSort.this.radixCalculator.radixOf(ParallelSort.this.comparator.dataValue(ParallelSort.this.dataCache.get(i)));
                if (rIndex <= this.lowRadixRange || rIndex > this.highRadixRange) continue;
                long trackerIndex = this.rangeParams[0] + this.bucketIndex++;
                assert (ParallelSort.this.tracker.get(trackerIndex) == -1L) : "Overlapping buckets i:" + i + ", k:" + this.threadIndex + ", index:" + trackerIndex;
                ParallelSort.this.tracker.set(trackerIndex, i);
                if (this.bucketIndex != this.rangeParams[1]) continue;
                this.result[0] = this.highRadixRange;
                this.result[1] = this.rangeParams[0];
            }
        }
    }

    private class SortWorker
    implements Runnable {
        private final long start;
        private final long size;
        private int threadLocalProgress;
        private final long[] pivotChoice = new long[10];
        private final ThreadLocalRandom random = ThreadLocalRandom.current();

        SortWorker(long startRange, long size2) {
            this.start = startRange;
            this.size = size2;
        }

        void incrementProgress(long diff2) {
            this.threadLocalProgress = (int)((long)this.threadLocalProgress + diff2);
            if (this.threadLocalProgress >= 10000) {
                this.reportProgress();
            }
        }

        private void reportProgress() {
            ParallelSort.this.progress.add(this.threadLocalProgress);
            this.threadLocalProgress = 0;
        }

        @Override
        public void run() {
            this.qsort(this.start, this.start + this.size);
            this.reportProgress();
        }

        private long partition(long leftIndex, long rightIndex, long pivotIndex) {
            long li = leftIndex;
            long ri = rightIndex - 2L;
            long pi = pivotIndex;
            long pivot = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(pi)));
            ParallelSort.this.tracker.swap(pi, rightIndex - 1L, 1);
            long left2 = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(li)));
            long right2 = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(ri)));
            while (li < ri) {
                if (ParallelSort.this.comparator.lt(left2, pivot)) {
                    left2 = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(++li)));
                    continue;
                }
                if (ParallelSort.this.comparator.ge(right2, pivot)) {
                    right2 = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(--ri)));
                    continue;
                }
                ParallelSort.this.tracker.swap(li, ri, 1);
                long temp = left2;
                left2 = right2;
                right2 = temp;
            }
            long partingIndex = ri;
            if (ParallelSort.this.comparator.lt(right2, pivot)) {
                ++partingIndex;
            }
            ParallelSort.this.tracker.swap(rightIndex - 1L, partingIndex, 1);
            return partingIndex;
        }

        private void qsort(long initialStart, long initialEnd) {
            PrimitiveLongStack stack = new PrimitiveLongStack(100);
            stack.push(initialStart);
            stack.push(initialEnd);
            while (!stack.isEmpty()) {
                long start;
                long end = stack.poll();
                long diff2 = end - (start = stack.poll());
                if (diff2 < 2L) {
                    this.incrementProgress(2L);
                    continue;
                }
                this.incrementProgress(1L);
                long pivot = start + this.random.nextLong(diff2);
                pivot = this.informedPivot(start, end, pivot);
                pivot = this.partition(start, end, pivot);
                if (pivot > start) {
                    stack.push(start);
                    stack.push(pivot);
                }
                if (pivot + 1L >= end) continue;
                stack.push(pivot + 1L);
                stack.push(end);
            }
        }

        private long informedPivot(long start, long end, long randomIndex) {
            if (end - start < (long)this.pivotChoice.length) {
                return randomIndex;
            }
            long low = Math.max(start, randomIndex - 5L);
            long high = Math.min(low + 10L, end);
            int length2 = Utils.safeCastLongToInt(high - low);
            int j = 0;
            long i = low;
            while (i < high) {
                this.pivotChoice[j] = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(i)));
                ++i;
                ++j;
            }
            Arrays.sort(this.pivotChoice, 0, length2);
            long middle = this.pivotChoice[length2 / 2];
            for (long i2 = low; i2 <= high; ++i2) {
                if (EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(i2))) != middle) continue;
                return i2;
            }
            throw new IllegalStateException("The middle value somehow disappeared in front of our eyes");
        }
    }

    public static interface Comparator {
        public boolean lt(long var1, long var3);

        public boolean ge(long var1, long var3);

        public long dataValue(long var1);
    }
}

