/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;

abstract class OffHeapRegularNumberArray<N extends NumberArray<N>>
extends OffHeapNumberArray<N> {
    protected final int shift;

    protected OffHeapRegularNumberArray(long length2, int shift, long base) {
        super(length2, 1 << shift, base);
        this.shift = shift;
    }

    protected long addressOf(long index) {
        if ((index = this.rebase(index)) < 0L || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Requested index " + index + ", but length is " + this.length);
        }
        return this.address + (index << this.shift);
    }

    protected boolean isByteUniform(long value) {
        byte any = (byte)value;
        for (int i = 1; i < this.itemSize; ++i) {
            byte test2 = (byte)(value >>> (i << 3));
            if (test2 == any) continue;
            return false;
        }
        return true;
    }
}

