/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.BaseNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public abstract class OffHeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    protected final long address;
    protected final long length;
    private boolean closed;

    protected OffHeapNumberArray(long length2, int itemSize, long base) {
        super(itemSize, base);
        UnsafeUtil.assertHasUnsafe();
        this.length = length2;
        this.address = UnsafeUtil.allocateMemory(length2 * (long)itemSize);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length * (long)this.itemSize);
    }

    @Override
    public void close() {
        if (!this.closed) {
            UnsafeUtil.free(this.address);
            this.closed = true;
        }
    }
}

