/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapByteArray
extends OffHeapNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;

    protected OffHeapByteArray(long length2, byte[] defaultValue, long base) {
        super(length2, defaultValue.length, base);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        int size2 = numberOfEntries * this.itemSize;
        long intermediary = UnsafeUtil.allocateMemory(size2);
        UnsafeUtil.copyMemory(this.address(fromIndex, 0), intermediary, size2);
        UnsafeUtil.copyMemory(this.address(toIndex, 0), this.address(fromIndex, 0), size2);
        UnsafeUtil.copyMemory(intermediary, this.address(toIndex, 0), size2);
        UnsafeUtil.free(intermediary);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory(this.address, this.length * (long)this.itemSize, this.defaultValue[0]);
        } else {
            long intermediary = UnsafeUtil.allocateMemory(this.itemSize);
            for (int i = 0; i < this.defaultValue.length; ++i) {
                UnsafeUtil.putByte(intermediary + (long)i, this.defaultValue[i]);
            }
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.copyMemory(intermediary, adr, this.itemSize);
                ++i;
                adr += (long)this.itemSize;
            }
            UnsafeUtil.free(intermediary);
        }
    }

    private boolean isByteUniform(byte[] bytes2) {
        byte reference = bytes2[0];
        for (int i = 1; i < bytes2.length; ++i) {
            if (reference == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            into[i] = UnsafeUtil.getByte(address);
            ++i;
            ++address;
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        return UnsafeUtil.getByte(this.address(index, offset));
    }

    @Override
    public short getShort(long index, int offset) {
        return UnsafeUtil.getShort(this.address(index, offset));
    }

    @Override
    public int getInt(long index, int offset) {
        return UnsafeUtil.getInt(this.address(index, offset));
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        long address = this.address(index, offset);
        long low4b = (long)UnsafeUtil.getInt(address) & 0xFFFFFFFFL;
        long high2b = UnsafeUtil.getShort(address + 4L);
        return low4b | high2b << 32;
    }

    @Override
    public long getLong(long index, int offset) {
        return UnsafeUtil.getLong(this.address(index, offset));
    }

    @Override
    public void set(long index, byte[] value) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            UnsafeUtil.putByte(address, value[i]);
            ++i;
            ++address;
        }
    }

    @Override
    public void setByte(long index, int offset, byte value) {
        UnsafeUtil.putByte(this.address(index, offset), value);
    }

    @Override
    public void setShort(long index, int offset, short value) {
        UnsafeUtil.putShort(this.address(index, offset), value);
    }

    @Override
    public void setInt(long index, int offset, int value) {
        UnsafeUtil.putInt(this.address(index, offset), value);
    }

    @Override
    public void set6ByteLong(long index, int offset, long value) {
        long address = this.address(index, offset);
        UnsafeUtil.putInt(address, (int)value);
        UnsafeUtil.putShort(address + 4L, (short)(value >>> 32));
    }

    @Override
    public void setLong(long index, int offset, long value) {
        UnsafeUtil.putLong(this.address(index, offset), value);
    }

    private long address(long index, int offset) {
        return this.address + this.rebase(index) * (long)this.itemSize + (long)offset;
    }
}

