/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeLabelsCache
implements MemoryStatsVisitor.Visitable {
    private final LongArray cache;
    private final LongArray spillOver;
    private long spillOverIndex;
    private final int bitsPerLabel;
    private final int worstCaseLongsNeeded;
    private final Client putClient;

    public NodeLabelsCache(NumberArrayFactory cacheFactory, int highLabelId) {
        this(cacheFactory, highLabelId, 10000000);
    }

    public NodeLabelsCache(NumberArrayFactory cacheFactory, int highLabelId, int chunkSize) {
        this.cache = cacheFactory.newDynamicLongArray(chunkSize, 0L);
        this.spillOver = cacheFactory.newDynamicLongArray(chunkSize / 5, 0L);
        this.bitsPerLabel = Math.max(32 - Integer.numberOfLeadingZeros(highLabelId), 1);
        this.worstCaseLongsNeeded = (this.bitsPerLabel * (highLabelId + 1) - 1) / 64 + 1;
        this.putClient = new Client(this.worstCaseLongsNeeded);
    }

    public Client newClient() {
        return new Client(this.worstCaseLongsNeeded);
    }

    public void put(long nodeId, long[] labelIds) {
        this.putClient.labelBits.clear(true);
        this.putClient.labelBits.put(labelIds.length, this.bitsPerLabel);
        for (long labelId : labelIds) {
            this.putClient.labelBits.put((int)labelId, this.bitsPerLabel);
        }
        int longsInUse = this.putClient.labelBits.longsInUse();
        assert (longsInUse > 0) : "Uhm";
        if (longsInUse == 1) {
            this.cache.set(nodeId, this.putClient.labelScratch[0]);
        } else {
            this.putClient.fieldBits.clear(true);
            this.putClient.fieldBits.put(labelIds.length, this.bitsPerLabel);
            this.putClient.fieldBits.put(this.spillOverIndex, 64 - this.bitsPerLabel);
            this.cache.set(nodeId, this.putClient.fieldBits.getLongs()[0]);
            for (int i = 0; i < longsInUse; ++i) {
                this.spillOver.set(this.spillOverIndex++, this.putClient.labelScratch[i]);
            }
        }
    }

    public int[] get(Client client, long nodeId, int[] target) {
        client.fieldBits.clear(false);
        ((Client)client).fieldScratch[0] = this.cache.get(nodeId);
        if (client.fieldScratch[0] == 0L) {
            target[0] = -1;
            return target;
        }
        int length2 = client.fieldBits.getInt(this.bitsPerLabel);
        int longsInUse = (this.bitsPerLabel * (length2 + 1) - 1) / 64 + 1;
        target = NodeLabelsCache.ensureCapacity(target, length2);
        if (longsInUse == 1) {
            this.decode(client.fieldBits, length2, target);
        } else {
            long spillOverIndex = client.fieldBits.getLong(64 - this.bitsPerLabel);
            client.labelBits.clear(false);
            for (int i = 0; i < longsInUse; ++i) {
                ((Client)client).labelScratch[i] = this.spillOver.get(spillOverIndex + (long)i);
            }
            client.labelBits.getInt(this.bitsPerLabel);
            this.decode(client.labelBits, length2, target);
        }
        return target;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
        this.spillOver.acceptMemoryStatsVisitor(visitor);
    }

    private void decode(Bits bits2, int length2, int[] target) {
        for (int i = 0; i < length2; ++i) {
            target[i] = bits2.getInt(this.bitsPerLabel);
        }
        if (target.length > length2) {
            target[length2] = -1;
        }
    }

    private static int[] ensureCapacity(int[] target, int capacity) {
        return capacity > target.length ? new int[capacity] : target;
    }

    public void close() {
        this.cache.close();
        this.spillOver.close();
    }

    public static class Client {
        private final long[] labelScratch;
        private final Bits labelBits;
        private final long[] fieldScratch = new long[1];
        private final Bits fieldBits = Bits.bitsFromLongs(this.fieldScratch);

        public Client(int worstCaseLongsNeeded) {
            this.labelScratch = new long[worstCaseLongsNeeded];
            this.labelBits = Bits.bitsFromLongs(this.labelScratch);
        }
    }
}

