/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.NoSuchElementException;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.SourceInputIterator;

public class Utils {
    public static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new ArithmeticException(Utils.getOverflowMessage(value, Integer.TYPE));
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if (value > 32767L) {
            throw new ArithmeticException(Utils.getOverflowMessage(value, Short.TYPE));
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if (value > 127L) {
            throw new ArithmeticException(Utils.getOverflowMessage(value, Byte.TYPE));
        }
        return (byte)value;
    }

    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return !(dataA < dataB ^ dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
        }
        return false;
    }

    public static CompareType unsignedDifference(long dataA, long dataB) {
        if (dataA == dataB) {
            return CompareType.EQ;
        }
        return dataA < dataB ^ dataA < 0L != dataB < 0L ? CompareType.LT : CompareType.GT;
    }

    public static InputIterable<Object> idsOf(final InputIterable<InputNode> nodes) {
        return new InputIterable<Object>(){

            @Override
            public InputIterator<Object> iterator() {
                ResourceIterator iterator2 = nodes.iterator();
                return new SourceInputIterator<Object, InputNode>((SourceTraceability)((Object)iterator2), (InputIterator)iterator2){
                    final /* synthetic */ InputIterator val$iterator;
                    {
                        this.val$iterator = inputIterator;
                        super(source);
                    }

                    @Override
                    public void close() {
                        this.val$iterator.close();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    @Override
                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return ((InputNode)this.val$iterator.next()).id();
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return false;
            }
        };
    }

    public static boolean anyIdCollides(long[] first, int firstLength, long[] other2, int otherLength) {
        int f = 0;
        int o = 0;
        while (f < firstLength && o < otherLength) {
            if (first[f] == other2[o]) {
                return true;
            }
            if (first[f] < other2[o]) {
                while (++f < firstLength && first[f] < other2[o]) {
                }
                continue;
            }
            while (++o < otherLength && first[f] > other2[o]) {
            }
        }
        return false;
    }

    public static void mergeSortedInto(long[] values2, long[] into, int intoLengthBefore) {
        int v = values2.length - 1;
        int i = intoLengthBefore - 1;
        int t = i + values2.length;
        while (v >= 0 || i >= 0) {
            if (i == -1) {
                into[t--] = values2[v--];
                continue;
            }
            if (v == -1) {
                into[t--] = into[i--];
                continue;
            }
            if (values2[v] >= into[i]) {
                into[t--] = values2[v--];
                continue;
            }
            into[t--] = into[i--];
        }
    }

    private static String getOverflowMessage(long value, Class clazz) {
        return "Value " + value + " is too big to be represented as " + clazz.getName();
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

