/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountGroupsStage;
import org.neo4j.unsafe.impl.batchimport.NodeFirstGroupStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupCache;
import org.neo4j.unsafe.impl.batchimport.ScanAndCacheGroupsStage;
import org.neo4j.unsafe.impl.batchimport.WriteGroupsStage;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class RelationshipGroupDefragmenter {
    private final Configuration config;
    private final ExecutionMonitor executionMonitor;

    public RelationshipGroupDefragmenter(Configuration config, ExecutionMonitor executionMonitor) {
        this.config = config;
        this.executionMonitor = executionMonitor;
    }

    public void run(long memoryWeCanHoldForCertain, BatchingNeoStores neoStore, long highNodeId) {
        try (RelationshipGroupCache groupCache = new RelationshipGroupCache(NumberArrayFactory.AUTO, memoryWeCanHoldForCertain, highNodeId);){
            try {
                RecordStore<RelationshipGroupRecord> fromStore = neoStore.getTemporaryRelationshipGroupStore();
                RecordStore<RelationshipGroupRecord> toStore = neoStore.getRelationshipGroupStore();
                this.executeStage(new CountGroupsStage(this.config, fromStore, groupCache));
                long fromNodeId = 0L;
                long toNodeId = 0L;
                while (fromNodeId < highNodeId) {
                    toNodeId = groupCache.prepare(fromNodeId);
                    this.executeStage(new ScanAndCacheGroupsStage(this.config, fromStore, groupCache));
                    this.executeStage(new WriteGroupsStage(this.config, groupCache, toStore));
                    fromNodeId = toNodeId;
                }
                ByteArray groupCountCache = groupCache.getGroupCountCache();
                groupCountCache.clear();
                this.executeStage(new NodeFirstGroupStage(this.config, toStore, neoStore.getNodeStore(), groupCountCache));
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }
}

