/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.ParallelizationCoordinator;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipEncoderStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final BatchingTokenRepository<?, ?> relationshipTypeRepository;
    private final NodeRelationshipCache cache;
    private final ParallelizationCoordinator parallelization = new ParallelizationCoordinator();

    public RelationshipEncoderStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, BatchingTokenRepository<?, ?> relationshipTypeRepository, NodeRelationshipCache cache) {
        super(control, "RELATIONSHIP", (Configuration)config, 0, new StatsProvider[0]);
        this.relationshipTypeRepository = relationshipTypeRepository;
        this.cache = cache;
    }

    @Override
    protected Resource permit(Batch<InputRelationship, RelationshipRecord> batch) {
        return this.parallelization.coordinate(batch.parallelizableWithPrevious);
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        InputRelationship[] input2 = (InputRelationship[])batch.input;
        batch.records = new RelationshipRecord[input2.length];
        long[] ids2 = batch.ids;
        long nextRelationshipId = batch.firstRecordId;
        for (int i = 0; i < input2.length; ++i) {
            long relationshipId;
            InputRelationship batchRelationship = input2[i];
            ++nextRelationshipId;
            long startNodeId = ids2[i * 2];
            long endNodeId = ids2[i * 2 + 1];
            if (startNodeId == -1L || endNodeId == -1L) {
                ((RelationshipRecord[])batch.records)[i] = new RelationshipRecord(relationshipId);
                ((RelationshipRecord[])batch.records)[i].setInUse(false);
                continue;
            }
            int typeId = batchRelationship.hasTypeId() ? batchRelationship.typeId() : this.relationshipTypeRepository.getOrCreateId(batchRelationship.type());
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationshipId, startNodeId, endNodeId, typeId);
            ((RelationshipRecord[])batch.records)[i] = relationshipRecord;
            RelationshipRecord relationshipRecord2 = relationshipRecord;
            relationshipRecord2.setInUse(true);
            boolean loop2 = startNodeId == endNodeId;
            long firstNextRel = this.cache.getAndPutRelationship(startNodeId, loop2 ? Direction.BOTH : Direction.OUTGOING, relationshipId, true);
            relationshipRecord2.setFirstNextRel(firstNextRel);
            if (loop2) {
                relationshipRecord2.setSecondNextRel(firstNextRel);
            } else {
                relationshipRecord2.setSecondNextRel(this.cache.getAndPutRelationship(endNodeId, Direction.INCOMING, relationshipId, true));
            }
            relationshipRecord2.setFirstInFirstChain(false);
            relationshipRecord2.setFirstInSecondChain(false);
            relationshipRecord2.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipRecord2.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
        }
        sender.send(batch);
    }
}

