/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public interface RecordProcessor<T extends AbstractBaseRecord> {
    public boolean process(T var1);

    public void done();

    public static class Multiple<T extends AbstractBaseRecord>
    implements RecordProcessor<T> {
        private final RecordProcessor<T>[] processors;

        @SafeVarargs
        public Multiple(RecordProcessor<T> ... processors) {
            this.processors = processors;
        }

        @Override
        public boolean process(T item) {
            boolean result2 = false;
            for (RecordProcessor<T> processor : this.processors) {
                result2 |= processor.process(item);
            }
            return result2;
        }

        @Override
        public void done() {
            for (RecordProcessor<T> processor : this.processors) {
                processor.done();
            }
        }
    }
}

