/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.MovingAverage;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.RelativeIdRecordAllocator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, RECORD>> {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder;
    private final int arrayDataSize;
    private final int stringDataSize;
    private final MovingAverage averageBlocksPerBatch;

    protected PropertyEncoderStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder, PropertyStore propertyStore) {
        super(control, "PROPERTIES", (Configuration)config, 0, new StatsProvider[0]);
        this.propertyKeyHolder = propertyKeyHolder;
        this.arrayDataSize = propertyStore.getArrayStore().getRecordDataSize();
        this.stringDataSize = propertyStore.getStringStore().getRecordDataSize();
        this.averageBlocksPerBatch = new MovingAverage(config.movingAverageSize());
    }

    @Override
    protected void process(Batch<INPUT, RECORD> batch, BatchSender sender) {
        RelativeIdRecordAllocator stringAllocator = new RelativeIdRecordAllocator(this.stringDataSize);
        RelativeIdRecordAllocator arrayAllocator = new RelativeIdRecordAllocator(this.arrayDataSize);
        PropertyCreator propertyCreator = new PropertyCreator(stringAllocator, arrayAllocator, null, null);
        int blockCountGuess = (int)this.averageBlocksPerBatch.average();
        PropertyBlock[] propertyBlocks = new PropertyBlock[blockCountGuess == 0 ? ((InputEntity[])batch.input).length : blockCountGuess + ((InputEntity[])batch.input).length / 20];
        int blockCursor = 0;
        int[] lengths = new int[((InputEntity[])batch.input).length];
        for (int i = 0; i < ((InputEntity[])batch.input).length; ++i) {
            stringAllocator.initialize();
            arrayAllocator.initialize();
            InputEntity input2 = ((InputEntity[])batch.input)[i];
            if (input2.hasFirstPropertyId()) continue;
            int count2 = input2.properties().length >> 1;
            if (blockCursor + count2 > propertyBlocks.length) {
                propertyBlocks = Arrays.copyOf(propertyBlocks, Math.max(propertyBlocks.length << 1, blockCursor + count2));
            }
            this.propertyKeyHolder.propertyKeysAndValues(propertyBlocks, blockCursor, input2.properties(), propertyCreator);
            lengths[i] = count2;
            blockCursor += count2;
        }
        batch.propertyBlocks = propertyBlocks;
        batch.propertyBlocksLengths = lengths;
        this.averageBlocksPerBatch.add(blockCursor);
        sender.send(batch);
    }
}

