/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.unsafe.impl.batchimport.Parallelizable;

public interface InputIterator<T>
extends ResourceIterator<T>,
SourceTraceability,
Parallelizable {

    public static class Empty<T>
    extends Adapter<T> {
        @Override
        protected T fetchNextOrNull() {
            return null;
        }
    }

    public static class Delegate<T>
    extends PrefetchingIterator<T>
    implements InputIterator<T> {
        protected final InputIterator<T> actual;

        public Delegate(InputIterator<T> actual2) {
            this.actual = actual2;
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        protected T fetchNextOrNull() {
            return this.actual.hasNext() ? (T)this.actual.next() : null;
        }

        @Override
        public String sourceDescription() {
            return this.actual.sourceDescription();
        }

        @Override
        public long lineNumber() {
            return this.actual.lineNumber();
        }

        @Override
        public long position() {
            return this.actual.position();
        }

        @Override
        public int processors(int delta) {
            return this.actual.processors(delta);
        }
    }

    public static abstract class Adapter<T>
    extends PrefetchingIterator<T>
    implements InputIterator<T> {
        private final SourceTraceability defaults = new SourceTraceability.Adapter(){

            @Override
            public String sourceDescription() {
                return Readables.EMPTY.sourceDescription();
            }
        };

        @Override
        public String sourceDescription() {
            return this.defaults.sourceDescription();
        }

        @Override
        public long lineNumber() {
            return this.defaults.lineNumber();
        }

        @Override
        public long position() {
            return this.defaults.position();
        }

        @Override
        public void close() {
        }
    }
}

