/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class IdRangeInput
extends PrefetchingIterator<Range> {
    private final long max;
    private final int batchSize;
    private long start;

    public IdRangeInput(long max2, int batchSize) {
        this.max = max2;
        this.batchSize = batchSize;
    }

    @Override
    protected Range fetchNextOrNull() {
        int count2 = (int)Long.min(this.batchSize, this.max - this.start);
        if (count2 == 0) {
            return null;
        }
        try {
            Range range2 = new Range(this.start, count2);
            return range2;
        }
        finally {
            this.start += (long)count2;
        }
    }

    public static Iterator<Range> idRangeInput(long max2, int batchSize) {
        return new IdRangeInput(max2, batchSize);
    }

    public static class Range {
        private final long start;
        private final int size;

        Range(long start, int size2) {
            this.start = start;
            this.size = size2;
        }

        public long getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }
    }
}

