/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.ReusableIteratorCostume;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class EntityStoreUpdaterStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, RECORD>> {
    private final CommonAbstractStore<RECORD, ? extends StoreHeader> entityStore;
    private final PropertyStore propertyStore;
    private final IoMonitor ioMonitor;
    private final PropertyCreator propertyCreator;
    private final Monitor monitor;
    private final BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
    private final ReusableIteratorCostume<PropertyBlock> blockIterator = new ReusableIteratorCostume();

    EntityStoreUpdaterStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, CommonAbstractStore<RECORD, ? extends StoreHeader> entityStore, PropertyStore propertyStore, IoMonitor ioMonitor, Monitor monitor) {
        super(control, "v", (Configuration)config, 1, ioMonitor);
        this.entityStore = entityStore;
        this.propertyStore = propertyStore;
        this.monitor = monitor;
        this.propertyCreator = new PropertyCreator(propertyStore, null);
        this.ioMonitor = ioMonitor;
        this.ioMonitor.reset();
    }

    @Override
    protected void process(Batch<INPUT, RECORD> batch, BatchSender sender) {
        this.propertyRecords.close();
        long highestId = 0L;
        RECORD[] records = batch.records;
        if (records.length == 0) {
            return;
        }
        int propertyBlockCursor = 0;
        int skipped = 0;
        for (int i = 0; i < records.length; ++i) {
            Object record = records[i];
            int propertyBlockCount = batch.propertyBlocksLengths[i];
            if (record != null) {
                InputEntity input2 = ((InputEntity[])batch.input)[i];
                if (input2.hasFirstPropertyId()) {
                    ((PrimitiveRecord)record).setNextProp(input2.firstPropertyId());
                } else if (propertyBlockCount > 0) {
                    EntityStoreUpdaterStep.reassignDynamicRecordIds(this.propertyStore, batch.propertyBlocks, propertyBlockCursor, propertyBlockCount);
                    long firstProp = this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.blockIterator.dressArray((PropertyBlock[])batch.propertyBlocks, propertyBlockCursor, propertyBlockCount), this.propertyRecords);
                    ((PrimitiveRecord)record).setNextProp(firstProp);
                }
                highestId = Math.max(highestId, ((AbstractBaseRecord)record).getId());
                this.entityStore.prepareForCommit(record);
                this.entityStore.updateRecord(record);
            } else {
                ++skipped;
            }
            propertyBlockCursor += propertyBlockCount;
        }
        this.entityStore.setHighestPossibleIdInUse(highestId);
        for (PropertyRecord propertyRecord : this.propertyRecords.records()) {
            this.propertyStore.updateRecord(propertyRecord);
        }
        this.monitor.entitiesWritten(records[0].getClass(), records.length - skipped);
        this.monitor.propertiesWritten(propertyBlockCursor);
    }

    static void reassignDynamicRecordIds(PropertyStore propertyStore, PropertyBlock[] blocks, int offset, int length2) {
        block4: for (int i = 0; i < length2; ++i) {
            PropertyBlock block = blocks[offset + i];
            PropertyType type = block.getType();
            switch (type) {
                case STRING: {
                    EntityStoreUpdaterStep.reassignDynamicRecordIds(block, type, propertyStore.getStringStore());
                    continue block4;
                }
                case ARRAY: {
                    EntityStoreUpdaterStep.reassignDynamicRecordIds(block, type, propertyStore.getArrayStore());
                    continue block4;
                }
            }
        }
    }

    static void reassignDynamicRecordIds(PropertyBlock block, PropertyType type, AbstractDynamicStore store) {
        Iterator<DynamicRecord> dynamicRecords = block.getValueRecords().iterator();
        long newId = store.nextId();
        block.getValueBlocks()[0] = PropertyStore.singleBlockLongValue(block.getKeyIndexId(), type, newId);
        while (dynamicRecords.hasNext()) {
            DynamicRecord dynamicRecord = dynamicRecords.next();
            dynamicRecord.setId(newId);
            if (!dynamicRecords.hasNext()) continue;
            newId = store.nextId();
            dynamicRecord.setNextBlock(newId);
        }
    }

    @Override
    protected void done() {
        super.done();
        this.ioMonitor.stop();
    }

    public static interface Monitor {
        public void entitiesWritten(Class<? extends PrimitiveRecord> var1, long var2);

        public void propertiesWritten(long var1);
    }
}

