/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;

public class CountingStoreUpdateMonitor
implements EntityStoreUpdaterStep.Monitor {
    private long nodes;
    private long relationships;
    private long properties;

    @Override
    public void entitiesWritten(Class<? extends PrimitiveRecord> type, long count2) {
        if (type.equals(NodeRecord.class)) {
            this.nodes += count2;
        } else if (type.equals(RelationshipRecord.class)) {
            this.relationships += count2;
        } else {
            throw new IllegalArgumentException(type.getName());
        }
    }

    @Override
    public void propertiesWritten(long count2) {
        this.properties += count2;
    }

    public long propertiesWritten() {
        return this.properties;
    }

    public long nodesWritten() {
        return this.nodes;
    }

    public long relationshipsWritten() {
        return this.relationships;
    }

    public String toString() {
        return String.format("Imported:%n  %d nodes%n  %d relationships%n  %d properties", this.nodes, this.relationships, this.properties);
    }
}

