/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;

public interface Configuration
extends org.neo4j.unsafe.impl.batchimport.staging.Configuration {
    public static final String BAD_FILE_NAME = "bad.log";
    public static final long MAX_PAGE_CACHE_MEMORY = ByteUnit.mebiBytes(240L);
    public static final Configuration DEFAULT = new Default();

    public int denseNodeThreshold();

    public long pageCacheMemory();

    public static class Overridden
    extends Configuration.Overridden
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public Overridden(Configuration defaults, Config config) {
            super(defaults);
            this.defaults = defaults;
            this.config = config;
        }

        public Overridden(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public long pageCacheMemory() {
            return Math.min(MAX_PAGE_CACHE_MEMORY, this.config.get(GraphDatabaseSettings.pagecache_memory));
        }

        @Override
        public int denseNodeThreshold() {
            return this.config.get(GraphDatabaseSettings.dense_node_threshold);
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }
    }

    public static class Default
    extends Configuration.Default
    implements Configuration {
        @Override
        public long pageCacheMemory() {
            return Math.min(MAX_PAGE_CACHE_MEMORY, Config.defaults().get(GraphDatabaseSettings.pagecache_memory));
        }

        @Override
        public int denseNodeThreshold() {
            return Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        }
    }
}

