/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.storageengine.api.Token;

class BatchTokenHolder {
    private final ArrayMap<String, Token> nameToToken = new ArrayMap(5, false, false);
    private final PrimitiveIntObjectMap<Token> idToToken = Primitive.intObjectMap(20);

    BatchTokenHolder(List<? extends Token> tokens) {
        for (Token token : tokens) {
            this.addToken(token);
        }
    }

    void addToken(Token token) {
        this.nameToToken.put(token.name(), token);
        this.idToToken.put(token.id(), token);
    }

    Token byId(int id) {
        return this.idToToken.get(id);
    }

    Token byName(String name2) {
        return this.nameToToken.get(name2);
    }
}

