/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;

public final class BatchInserters {
    public static BatchInserter inserter(File storeDir) throws IOException {
        return BatchInserters.inserter(storeDir, MapUtil.stringMap(new String[0]));
    }

    public static BatchInserter inserter(File storeDir, FileSystemAbstraction fs) throws IOException {
        return BatchInserters.inserter(storeDir, fs, MapUtil.stringMap(new String[0]), Service.load(KernelExtensionFactory.class));
    }

    public static BatchInserter inserter(File storeDir, Map<String, String> config) throws IOException {
        return BatchInserters.inserter(storeDir, new DefaultFileSystemAbstraction(), config, Service.load(KernelExtensionFactory.class));
    }

    public static BatchInserter inserter(File storeDir, FileSystemAbstraction fs, Map<String, String> config) throws IOException {
        return BatchInserters.inserter(storeDir, fs, config, Service.load(KernelExtensionFactory.class));
    }

    public static BatchInserter inserter(File storeDir, Map<String, String> config, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        return new BatchInserterImpl(storeDir, new DefaultFileSystemAbstraction(), config, kernelExtensions);
    }

    public static BatchInserter inserter(File storeDir, FileSystemAbstraction fileSystem, Map<String, String> config, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        return new BatchInserterImpl(storeDir, fileSystem, config, kernelExtensions);
    }
}

