/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class UTF8 {
    public static final Function<String, byte[]> encode = UTF8::encode;
    public static final Function<byte[], String> decode = UTF8::decode;

    public static byte[] encode(String string2) {
        return string2.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes2) {
        return new String(bytes2, StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes2, int offset, int length2) {
        return new String(bytes2, offset, length2, StandardCharsets.UTF_8);
    }

    public static String getDecodedStringFrom(ByteBuffer source) {
        int count2 = source.getInt();
        byte[] data = new byte[count2];
        source.get(data);
        return UTF8.decode(data);
    }

    public static void putEncodedStringInto(String text2, ByteBuffer target) {
        byte[] data = UTF8.encode(text2);
        target.putInt(data.length);
        target.put(data);
    }

    public static int computeRequiredByteBufferSize(String text2) {
        return UTF8.encode(text2).length + 4;
    }

    private UTF8() {
    }
}

