/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Set
extends TransactionProvidingApp {
    private static final Map<String, ValueType> NAME_TO_VALUE_TYPE = new HashMap<String, ValueType>();
    private static final Map<Class<?>, String> VALUE_TYPE_TO_NAME;

    private static void mapNameToValueType(ValueTypeContext context) {
        NAME_TO_VALUE_TYPE.put(context.getName(), new ValueType(context, false));
        NAME_TO_VALUE_TYPE.put(context.getArrayName(), new ValueType(context, true));
    }

    public Set() {
        this.addOptionDefinition("t", new OptionDefinition(OptionValueType.MUST, "Value type, f.ex: String, String[], int, long[], byte a.s.o. If an array type is supplied the value(s) are given in a JSON-style array format, f.ex:\n[321,45324] for an int[] or\n\"['The first string','The second string here']\" for a String[]"));
        this.addOptionDefinition("p", new OptionDefinition(OptionValueType.NONE, "Tells the command to set the supplied values as property."));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MUST, "Sets one or more labels on the current node."));
    }

    @Override
    public String getDescription() {
        return "Sets a property on the current node or relationship or label on the current node.\nUsage:\n  set <key> <value>\n  set -p <key> <value>\n  set -l PERSON";
    }

    protected static String getValueTypeName(Class<?> cls) {
        return VALUE_TYPE_TO_NAME.get(cls);
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        boolean forProperty = parser.options().containsKey("p");
        boolean forLabel = parser.options().containsKey("l");
        if (forProperty || !forLabel) {
            if (parser.arguments().size() < 2) {
                throw new ShellException("Must supply key and value, like: set title \"This is a my title\"");
            }
            String key = parser.arguments().get(0);
            ValueType valueType = Set.getValueType(parser);
            Object value = Set.parseValue(parser.arguments().get(1), valueType);
            NodeOrRelationship thing = this.getCurrent(session);
            thing.setProperty(key, value);
        } else {
            Node node = this.getCurrent(session).asNode();
            for (Label label : this.parseLabels(parser)) {
                node.addLabel(label);
            }
        }
        return Continuation.INPUT_COMPLETE;
    }

    private static Object parseValue(String stringValue, ValueType valueType) {
        Object result2 = null;
        if (valueType.isArray) {
            Class componentType = valueType.context.boxClass;
            Object[] rawArray = Set.parseArray(stringValue);
            result2 = Array.newInstance(componentType, rawArray.length);
            for (int i = 0; i < rawArray.length; ++i) {
                Array.set(result2, i, Set.parseValue(rawArray[i].toString(), componentType));
            }
        } else {
            Class componentType = valueType.context.boxClass;
            result2 = Set.parseValue(stringValue, componentType);
        }
        return result2;
    }

    private static Object parseValue(String value, Class<?> type) {
        Object result2 = null;
        if (type.equals(String.class)) {
            result2 = value;
        } else if (type.equals(Boolean.class)) {
            result2 = Boolean.parseBoolean(value);
        } else if (type.equals(Byte.class)) {
            result2 = Byte.parseByte(value);
        } else if (type.equals(Character.class)) {
            result2 = Character.valueOf(value.charAt(0));
        } else if (type.equals(Short.class)) {
            result2 = Short.parseShort(value);
        } else if (type.equals(Integer.class)) {
            result2 = Integer.parseInt(value);
        } else if (type.equals(Long.class)) {
            result2 = Long.parseLong(value);
        } else if (type.equals(Float.class)) {
            result2 = Float.valueOf(Float.parseFloat(value));
        } else if (type.equals(Double.class)) {
            result2 = Double.parseDouble(value);
        } else {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return result2;
    }

    private static ValueType getValueType(AppCommandParser parser) throws ShellException {
        String type = parser.options().containsKey("t") ? parser.options().get("t") : String.class.getSimpleName();
        ValueType valueType = NAME_TO_VALUE_TYPE.get(type);
        if (valueType == null) {
            throw new ShellException("Invalid value type '" + type + "'");
        }
        return valueType;
    }

    static {
        Set.mapNameToValueType(new ValueTypeContext(Boolean.TYPE, Boolean.class, boolean[].class, Boolean[].class));
        Set.mapNameToValueType(new ValueTypeContext(Byte.TYPE, Byte.class, byte[].class, Byte[].class));
        Set.mapNameToValueType(new ValueTypeContext(Character.TYPE, Character.class, char[].class, Character[].class));
        Set.mapNameToValueType(new ValueTypeContext(Short.TYPE, Short.class, short[].class, Short[].class));
        Set.mapNameToValueType(new ValueTypeContext(Integer.TYPE, Integer.class, int[].class, Integer[].class));
        Set.mapNameToValueType(new ValueTypeContext(Long.TYPE, Long.class, long[].class, Long[].class));
        Set.mapNameToValueType(new ValueTypeContext(Float.TYPE, Float.class, float[].class, Float[].class));
        Set.mapNameToValueType(new ValueTypeContext(Double.TYPE, Double.class, double[].class, Double[].class));
        Set.mapNameToValueType(new ValueTypeContext(String.class, String.class, String[].class, String[].class));
        VALUE_TYPE_TO_NAME = new HashMap();
        for (Map.Entry<String, ValueType> entry : NAME_TO_VALUE_TYPE.entrySet()) {
            ValueTypeContext context = entry.getValue().context;
            VALUE_TYPE_TO_NAME.put(context.fundamentalClass, context.getName());
            VALUE_TYPE_TO_NAME.put(context.boxClass, context.getName());
            VALUE_TYPE_TO_NAME.put(context.fundamentalArrayClass, context.getArrayName());
            VALUE_TYPE_TO_NAME.put(context.boxArrayClass, context.getArrayName());
        }
    }

    private static class ValueType {
        private final ValueTypeContext context;
        private final boolean isArray;

        ValueType(ValueTypeContext context, boolean isArray) {
            this.context = context;
            this.isArray = isArray;
        }
    }

    private static class ValueTypeContext {
        private final Class<?> fundamentalClass;
        private final Class<?> boxClass;
        private final Class<?> fundamentalArrayClass;
        private final Class<?> boxArrayClass;

        ValueTypeContext(Class<?> fundamentalClass, Class<?> boxClass, Class<?> fundamentalArrayClass, Class<?> boxArrayClass) {
            this.fundamentalClass = fundamentalClass;
            this.boxClass = boxClass;
            this.fundamentalArrayClass = fundamentalArrayClass;
            this.boxArrayClass = boxArrayClass;
        }

        public String getName() {
            return this.fundamentalClass.equals(this.boxClass) ? this.boxClass.getSimpleName() : this.fundamentalClass.getSimpleName();
        }

        public String getArrayName() {
            return this.getName() + "[]";
        }
    }
}

