/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.ColumnPrinter;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Schema
extends TransactionProvidingApp {
    private static final String INDENT = "  ";
    private static final Function<IndexDefinition, String> LABEL_COMPARE_FUNCTION = index -> index.getLabel().name();

    public Schema() {
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MUST, "Specifies which label selected operation is about"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.MUST, "Specifies which relationship type selected operation is about"));
        this.addOptionDefinition("p", new OptionDefinition(OptionValueType.MUST, "Specifies which property selected operation is about"));
        this.addOptionDefinition("a", new OptionDefinition(OptionValueType.NONE, "Used together with schema sample to indicate that all indexes should be sampled"));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.NONE, "Used together with schema sample to force indexes to be sampled"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose output of failure descriptions etc."));
    }

    @Override
    public String getDescription() {
        return "Accesses db schema. Usage: schema <action> <options...>\nListing indexes\n  schema ls\n  schema ls -l :Person\n  schema ls -r :KNOWS\nSample all indexes\n  schema sample -a\nSample a specific index\n  schema sample -l :Person -p name\n  schema sample -r :KNOWS -p since\nForce a sampling of a specific index\n  schema sample -f -l :Person -p name\nAwaiting indexes to come online\n  schema await -l :Person -p name\nPrint indexing progress\n  schema progress\n  schema progress -l :Person\n  schema progress -l :Person -p name";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        String action = parser.argumentWithDefault(0, "ls");
        org.neo4j.graphdb.schema.Schema schema = this.getServer().getDb().schema();
        Label[] labels2 = this.parseLabels(parser);
        RelationshipType[] relTypes = this.parseRelTypes(parser);
        String property = parser.option("p", null);
        boolean sampleAll = parser.options().containsKey("a");
        boolean forceSample = parser.options().containsKey("f");
        boolean verbose = parser.options().containsKey("v");
        switch (action) {
            case "await": {
                if (relTypes.length > 0) {
                    throw new ShellException("It is only possible to await nodes related index");
                }
                this.awaitIndexes(out, schema, labels2, property);
                break;
            }
            case "progress": {
                if (relTypes.length > 0) {
                    throw new ShellException("It is only possible to show progress on nodes related index");
                }
                this.printIndexProgress(out, schema, labels2, property);
                break;
            }
            case "ls": {
                this.listIndexesAndConstraints(out, schema, labels2, relTypes, property, verbose);
                break;
            }
            case "sample": {
                if (relTypes.length > 0) {
                    throw new ShellException("It is only possible to sample nodes related index");
                }
                this.sampleIndexes(labels2, property, sampleAll, forceSample);
                break;
            }
            default: {
                out.println((Serializable)((Object)("Unknown action: " + action + "\nUSAGE:\n" + this.getDescription())));
            }
        }
        return Continuation.INPUT_COMPLETE;
    }

    private void listIndexesAndConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, RelationshipType[] relTypes, String property, boolean verbose) throws RemoteException {
        if (labels2.length > 0 && relTypes.length == 0) {
            this.listNodeIndexesAndConstraints(out, schema, labels2, property, verbose);
        } else if (relTypes.length > 0 && labels2.length == 0) {
            this.listRelationshipIndexesAndConstraints(out, schema, relTypes, property, verbose);
        } else {
            this.listAllIndexesAndConstraints(out, schema, labels2, relTypes, property, verbose);
        }
    }

    private void sampleIndexes(Label[] labels2, String property, boolean sampleAll, boolean forceSample) throws ShellException {
        IndexingService indexingService = this.getServer().getDb().getDependencyResolver().resolveDependency(IndexingService.class);
        if (indexingService == null) {
            throw new ShellException("Internal error: failed to resolve IndexingService");
        }
        IndexSamplingMode samplingMode = this.getSamplingMode(forceSample);
        if (sampleAll) {
            indexingService.triggerIndexSampling(samplingMode);
            return;
        }
        this.validateLabelsAndProperty(labels2, property);
        Statement statement = this.getServer().getStatement();
        int labelKey = statement.readOperations().labelGetForName(labels2[0].name());
        int propertyKey = statement.readOperations().propertyKeyGetForName(property);
        if (labelKey == -1) {
            throw new ShellException("No label associated with '" + labels2[0].name() + "' was found");
        }
        if (propertyKey == -1) {
            throw new ShellException("No property associated with '" + property + "' was found");
        }
        indexingService.triggerIndexSampling(new IndexDescriptor(labelKey, propertyKey), samplingMode);
    }

    private IndexSamplingMode getSamplingMode(boolean forceSample) {
        if (forceSample) {
            return IndexSamplingMode.TRIGGER_REBUILD_ALL;
        }
        return IndexSamplingMode.TRIGGER_REBUILD_UPDATED;
    }

    private void validateLabelsAndProperty(Label[] labels2, String property) throws ShellException {
        if (labels2.length == 0 && property == null) {
            throw new ShellException("Invalid usage of sample. \nUSAGE:\n" + this.getDescription());
        }
        if (labels2.length > 1) {
            throw new ShellException("Only one label must be provided");
        }
        if (property == null || labels2.length == 0) {
            throw new ShellException("Provide both the property and the label, or run with -a to sample all indexes");
        }
    }

    private void printIndexProgress(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property) throws RemoteException {
        for (IndexDefinition index : this.indexesByLabelAndProperty(schema, labels2, property)) {
            out.println((Serializable)((Object)String.format("%s: %1.1f%%", index.getLabel().name(), Float.valueOf(schema.getIndexPopulationProgress(index).getCompletedPercentage()))));
        }
    }

    private void awaitIndexes(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property) throws RemoteException {
        for (IndexDefinition index : this.indexesByLabelAndProperty(schema, labels2, property)) {
            if (schema.getIndexState(index) == Schema.IndexState.ONLINE) continue;
            out.println((Serializable)((Object)String.format("Awaiting :%s ON %s %s", new Object[]{index.getLabel().name(), Iterables.asList(index.getPropertyKeys()), Schema.IndexState.ONLINE})));
            schema.awaitIndexOnline(index, 10000L, TimeUnit.DAYS);
        }
    }

    private void listNodeIndexesAndConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property, boolean verbose) throws RemoteException {
        this.reportNodeIndexes(out, schema, labels2, property, verbose);
        this.reportNodeConstraints(out, schema, labels2, property);
    }

    private void listRelationshipIndexesAndConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, RelationshipType[] types2, String property, boolean verbose) throws RemoteException {
        this.reportRelationshipConstraints(out, schema, types2, property);
    }

    private void listAllIndexesAndConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, RelationshipType[] types2, String property, boolean verbose) throws RemoteException {
        this.reportNodeIndexes(out, schema, labels2, property, verbose);
        this.reportAllConstraints(out, schema, labels2, types2, property);
    }

    private void reportNodeConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property) throws RemoteException {
        Iterable<ConstraintDefinition> nodeConstraints = this.constraintsByLabelAndProperty(schema, labels2, property);
        this.reportConstraints(out, nodeConstraints);
    }

    private void reportRelationshipConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, RelationshipType[] types2, String property) throws RemoteException {
        Iterable<ConstraintDefinition> relConstraints = this.constraintsByTypeAndProperty(schema, types2, property);
        this.reportConstraints(out, relConstraints);
    }

    private void reportAllConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, RelationshipType[] types2, String property) throws RemoteException {
        Iterable<ConstraintDefinition> allConstraints = Iterables.concat(this.constraintsByLabelAndProperty(schema, labels2, property), this.constraintsByTypeAndProperty(schema, types2, property));
        this.reportConstraints(out, allConstraints);
    }

    private void reportConstraints(Output out, Iterable<ConstraintDefinition> constraints) throws RemoteException {
        int j = 0;
        for (ConstraintDefinition constraint : constraints) {
            if (j == 0) {
                out.println();
                out.println((Serializable)((Object)"Constraints"));
            }
            out.println((Serializable)((Object)Schema.indent(constraint.toString())));
            ++j;
        }
        if (j == 0) {
            out.println();
            out.println((Serializable)((Object)"No constraints"));
        }
    }

    private void reportNodeIndexes(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property, boolean verbose) throws RemoteException {
        ColumnPrinter printer = new ColumnPrinter(Schema.indent("ON "), "", "");
        Iterable<IndexDefinition> indexes = this.indexesByLabelAndProperty(schema, labels2, property);
        int i = 0;
        for (IndexDefinition index : Iterables.sort(indexes, LABEL_COMPARE_FUNCTION)) {
            if (i == 0) {
                out.println((Serializable)((Object)"Indexes"));
            }
            String labelAndProperties = String.format(":%s(%s)", index.getLabel().name(), this.commaSeparate(index.getPropertyKeys()));
            Schema.IndexState state = schema.getIndexState(index);
            String uniqueOrNot = index.isConstraintIndex() ? "(for uniqueness constraint)" : "";
            printer.add(new Object[]{labelAndProperties, state, uniqueOrNot});
            if (verbose && state == Schema.IndexState.FAILED) {
                printer.addRaw(schema.getIndexFailure(index));
            }
            ++i;
        }
        if (i == 0) {
            out.println((Serializable)((Object)"No indexes"));
        } else {
            printer.print(out);
        }
    }

    private String commaSeparate(Iterable<String> keys2) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String key : keys2) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(key);
        }
        return builder.toString();
    }

    private Iterable<IndexDefinition> indexesByLabelAndProperty(org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property) {
        Iterable<IndexDefinition> indexes = this.indexesByLabel(schema, labels2);
        if (property != null) {
            indexes = Iterables.filter(index -> Iterables.indexOf(property, index.getPropertyKeys()) != -1, indexes);
        }
        return indexes;
    }

    private Iterable<ConstraintDefinition> constraintsByLabelAndProperty(org.neo4j.graphdb.schema.Schema schema, Label[] labels2, String property) {
        return Iterables.filter(constraint -> Schema.isNodeConstraint(constraint) && this.hasLabel((ConstraintDefinition)constraint, labels2) && this.isMatchingConstraint((ConstraintDefinition)constraint, property), schema.getConstraints());
    }

    private Iterable<ConstraintDefinition> constraintsByTypeAndProperty(org.neo4j.graphdb.schema.Schema schema, RelationshipType[] types2, String property) {
        return Iterables.filter(constraint -> Schema.isRelationshipConstraint(constraint) && Schema.hasType(constraint, types2) && this.isMatchingConstraint((ConstraintDefinition)constraint, property), schema.getConstraints());
    }

    private boolean hasLabel(ConstraintDefinition constraint, Label[] labels2) {
        if (labels2.length == 0) {
            return true;
        }
        for (Label label : labels2) {
            if (!constraint.getLabel().name().equals(label.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasType(ConstraintDefinition constraint, RelationshipType[] types2) {
        if (types2.length == 0) {
            return true;
        }
        for (RelationshipType type : types2) {
            if (!constraint.getRelationshipType().name().equals(type.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNodeConstraint(ConstraintDefinition constraint) {
        return constraint.isConstraintType(ConstraintType.UNIQUENESS) || constraint.isConstraintType(ConstraintType.NODE_PROPERTY_EXISTENCE);
    }

    private static boolean isRelationshipConstraint(ConstraintDefinition constraint) {
        return constraint.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE);
    }

    private boolean isMatchingConstraint(ConstraintDefinition constraint, String property) {
        if (property == null) {
            return true;
        }
        return Iterables.indexOf(property, constraint.getPropertyKeys()) != -1;
    }

    private Iterable<IndexDefinition> indexesByLabel(org.neo4j.graphdb.schema.Schema schema, Label[] labels2) {
        Iterable<IndexDefinition> indexes = schema.getIndexes();
        for (Label label : labels2) {
            indexes = Iterables.filter(item -> item.getLabel().name().equals(label.name()), indexes);
        }
        return indexes;
    }

    private static String indent(String str2) {
        return INDENT + str2;
    }
}

